% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{GetStrandedKmerCounts}
\alias{GetStrandedKmerCounts}
\title{Generate stranded k-mer abundance from a given genome and gene annotation file}
\usage{
GetStrandedKmerCounts(
  k,
  ref.genome,
  stranded.ranges,
  filter.path,
  verbose = FALSE
)
}
\arguments{
\item{k}{Length of k-mers (k>=2)}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{stranded.ranges}{A keyed data table which has stranded ranges
information. It has four columns: chrom, start, end and strand. It should
use one-based coordinate system.}

\item{filter.path}{If given, homopolymers will be masked from
genome(sequence). Only simple repeat masking is accepted now.}

\item{verbose}{If \code{TRUE} generate progress messages.}
}
\value{
Matrix of the counts of each stranded k-mer across the \code{ref.genome}
}
\description{
Generate stranded k-mer abundance from a given genome and gene annotation file
}
\keyword{internal}
