% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OrdinaryCalibration.R
\name{FitCalibWeibull}
\alias{FitCalibWeibull}
\title{Fitting Weibull Calibration Models}
\usage{
FitCalibWeibull(w, w.res)
}
\arguments{
\item{w}{A matrix of time points when measurements on the binary covariate were obtained.}

\item{w.res}{A matrix of measurement results of the binary covariate. It corresponds to the time points in \code{w}}
}
\value{
A bivariate vector: the estimated Weibull shape and scale parameters
}
\description{
Fits a Weibull calibration model for time-to-exposure from interval-censored data. The exposure is a binary covariate measured
in intermittent times.
}
\examples{
# Simulate data set
sim.data <- ICcalib:::SimCoxIntervalCensSingle(n.sample = 200, lambda = 0.1, 
                                               alpha = 0.25, beta0 = log(0.5), 
                                               mu = 0.2, n.points = 2, 
                                               weib.shape = 1, weib.scale = 2)
# Fit a Weibull calibration model for the covariate starting time distribution
ICcalib::FitCalibWeibull(w = sim.data$w, w.res = sim.data$w.res) 
}
\seealso{
\code{\link[fitdistrplus]{fitdistcens}}
}
