% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DispFieldbb.R
\name{DispFieldbb}
\alias{DispFieldbb}
\title{Displacement fields based on 2D cross-covariance using bounding box}
\usage{
DispFieldbb(
  inputrast1,
  inputrast2,
  rowmn,
  rowmx,
  colmn,
  colmx,
  restricted = FALSE
)
}
\arguments{
\item{inputrast1}{a raster as produced by terra::rast}

\item{inputrast2}{a raster of equivalent dimension to inputrast1 as produced
by terra::rast}

\item{rowmn}{an integer denoting the minimum row index of the sub-grid}

\item{rowmx}{an integer denoting the maximum row index of the sub-grid}

\item{colmn}{an integer denoting the minimum column index of the sub-grid}

\item{colmx}{an integer denoting the maximum column index of the sub-grid}

\item{restricted}{logical (TRUE or FALSE)}
}
\value{
A data frame is returned with the following column names: rowcent,
colcent, frowmin, frowmax, fcolmin, fcolmax, centx, centy, dispx, and
dispy. The rowcent and colcent column names are the row and column indices
for the center of the sub-grid; frowmin and frowmax are the sub-grid
minimum and maximum row indices; fcolmin and fcolmax are the sub-grid
minimum and maximum column indices; centx and centy are the projected
coordinates of the centre of the subgrid derived from the raster input
files; dispx and dispy are the displacement in the horizontal and vertical
directions in the same units as the projected coordinates of the raster
input files.
}
\description{
Calculates a displacement field based on the cross-covariance of two input
rasters presumably representing spatial population abundance or density at
two different instances of time. This version differs from
\code{\link{DispField}} in that the user defines a bounding box that
determines a single sub-grid. The center of the bounding box is the location
from whence displacement is estimated.
}
\details{
The input rasters are first converted to equivalent matrices. If restricted
is set to FALSE (the default), the function computes cross-covariance between
the sub-grid of the first input raster and the entirety of the second input
raster and then uses the location of maximum cross-covariance to estimate
displacement in the vertical and horizontal directions from the centre of the
sub-grid.

If restricted is set to TRUE, the function uses cross-covariance between the
sub-grid of the first input raster and the equivalent sub-grid of the second
input raster to estimate vertical and horizontal displacement.

Reference coordinates and cell size are extracted from the first input raster
such that the locations from whence displacement is estimated as well as
displacement estimates can be expressed in the units of the projected
coordinates.

The coordinates are assumed to increase vertically and horizontally from the
lower left corner of the two-dimensional domain.

Caution is warranted when defining the bounding box because the function can
produce erroneous results when the bounding box is too small.
}
\examples{
rseq <- stats::runif(72)
Mat1 <- matrix(rep(0, 81), nrow = 9)
Mat2 <- Mat1
Mat1[1:9, 1:8] <- rseq
Mat1
Mat2[1:9, 2:9] <- rseq
Mat2

# Note that rasterizing a matrix causes it to be rotated 90 degrees.
# Therefore, any shift in the x direction is in fact now a shift in the y direction
rast1 <- terra::rast(Mat1)
terra::plot(rast1)
rast2 <- terra::rast(Mat2)
terra::plot(rast2)

(VFdf1 <- DispFieldbb(rast1, rast2, 2, 8, 2, 8))
# The second raster is shifted down by 0.1111111 units relative to the first raster
# dispy = -0.1111111
}
\seealso{
\code{\link{DispField}} for a similar function with a grid of focal
regions, \code{\link{DispFieldSTbb}} for a version designed to quantify
persistent directional movement when the time series features more than two
time instances, \code{\link{DispFieldSTbball}} for a version designed to
quantify persistent directional movement when velocity is variable in
space, and \code{\link{Xcov2D}} for demonstration of how two-dimensional
cross-covariance is used to determine displacement (see examples of Xcov2D
function documentation).
}
