% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_idea.R
\name{write_idea}
\alias{write_idea}
\title{Write IDEA4 results and graphs to local disc}
\usage{
write_idea(
  IDEA_plots,
  output_directory,
  type = c("local", "report"),
  prefix = NULL,
  dpi = 320,
  report_format = "docx",
  append = FALSE,
  input_file_append = NULL,
  quiet = FALSE
)
}
\arguments{
\item{IDEA_plots}{an IDEA_plots or IDEA_group_plots object from a \code{plot_idea()} call.}

\item{output_directory}{the desired output directory for the rendered reports and/or plots. Defaults to "IDEATools_output"}

\item{type}{the type of output to produce. Can be either "report" to produce compiled reports or "local" to write raw plots as PNG files.}

\item{prefix}{a prefix which will be added to output files names. Typically, the name of the farm. Ignored in the case of a group analysis : The \code{metadata$MTD_01} field will then be used to identify each farm.}

\item{dpi}{ggplot output resolution.}

\item{report_format}{a string indicating the output format if \code{type = "report"}. Can be a single format (e.g \code{"pdf"}) or multiple formats (e.g. \code{c("pdf","xlsx")}). Possible formats are "pdf", "docx", "pptx" and "xlsx"}

\item{append}{If the input is an xlsx format, should the individual output be appended to the original file ?}

\item{input_file_append}{file path to an xslx IDEA data spreadsheet}

\item{quiet}{A command to remove console printing.}
}
\value{
Reports and/or raw plots in \code{output_directory}.
}
\description{
This function allows the user to write IDEA4 results either as local PNG files or compiled in reports.
}
\details{
This function automatically creates in \code{output_directory} a subdirectory named after the system date for users to use the same output_directory for multiple diagnosis.

Inputs of class \code{IDEA_plots} can be generated by a classic \code{read_idea() |> compute_idea() |> plot_idea()} or \code{old_idea() |> plot_idea()} individual analysis pipelines. Inputs of class \code{IDEA_group_plots} can only be generated by a \code{plot_idea()} call in a group analysis conducted by \code{diag_idea}.

In the case of an individual analysis, another subdirectory is created with \code{prefix} as a name so that analyses are not mixed up. The user can choose if output should be raw plots (that can be used in custom reports) or pre-compiled reports with a large variety of available formats.

In the case of a group analysis, another subdirectory is created with a name like "Groupe_{number_of_farms}" so that analyses are not mixed up. The user can again choose if output should be raw plots or pre-compiled reports.

If the \code{report_format} argument is set to either "docx" or "pptx", the report will be rendered using the {rmarkdown} package (and {officedown}/{officer} packages for the docx output) using a template stored in this package. For "pdf" output, LaTeX will be called with the {rmarkdown} package. For "xlsx" output, the {openxlsx} package will be used to sequentially produce Excel worksheets and files, using an internal R function.

Please note that an error will be produced if the input object does not contain all three "dimensions","trees" and "radars" entries in the case of an individual analysis and if \code{type = "report"}.
}
\examples{
library(IDEATools)
path <- system.file("example_data/idea_example_1.json", package = "IDEATools")
my_data <- read_idea(path)
computed_data <- compute_idea(my_data)
# Only plotting the radars as a minimal example
idea_plots <- plot_idea(computed_data, choices = "radars") 
# Find your temporary directory
tempdir <- tempdir()

# Export as raw plots to your tempdir
write_idea(idea_plots,
  output_directory = tempdir,
  type = "local",
  prefix = "myFarm",
  dpi = 20 # Can be much higher
)
}
