% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.tau.permute}
\alias{get.tau.permute}
\title{get the null distribution of the \code{get.tau} function}
\usage{
get.tau.permute(posmat, fun, r = 1, r.low = rep(0, length(r)), permutations,
  comparison.type = "representative")
}
\arguments{
\item{posmat}{a matrix appropriate for input to \code{get.tau}}

\item{fun}{a function appropriate for input to \code{get.tau}}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{permutations}{the number of permute iterations}

\item{comparison.type}{the comparison type to pass as input to \code{get.pi}}
}
\value{
tau values for all the distances we looked at
}
\description{
Does permutations to calculate the null distribution of get pi
if there were no spatial dependence. Randomly reassigns coordinates
to each observation permutations times
}
\examples{
\dontrun{
 R/examples/get_tau_permute.R
 }

}
\author{
Justin Lessler and Henrik Salje
}
\seealso{
Other get.tau: \code{\link{get.tau.bootstrap}},
  \code{\link{get.tau.ci}},
  \code{\link{get.tau.typed.bootstrap}},
  \code{\link{get.tau.typed.permute}},
  \code{\link{get.tau.typed}}, \code{\link{get.tau}}
}

