% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IFAAfunc.R
\name{IFAA}
\alias{IFAA}
\title{Robust association identification and inference for absolute abundance in microbiome analyses}
\usage{
IFAA(
  MicrobData,
  CovData,
  linkIDname,
  testCov = NULL,
  ctrlCov = NULL,
  testMany = TRUE,
  ctrlMany = FALSE,
  nRef = 40,
  nRefMaxForEsti = 2,
  refTaxa = NULL,
  adjust_method = "BY",
  fdrRate = 0.15,
  paraJobs = NULL,
  bootB = 500,
  standardize = FALSE,
  sequentialRun = FALSE,
  refReadsThresh = 0.2,
  taxDropThresh = 0,
  SDThresh = 0.05,
  SDquantilThresh = 0,
  balanceCut = 0.2,
  seed = 1
)
}
\arguments{
\item{MicrobData}{Microbiome data matrix containing microbiome absolute abundance or relative abundance with each row per
sample and each column per taxon/OTU/ASV (or any other unit). It should contain an id variable to be linked with
the id variable in the covariates data: \code{CovData}. This argument can take
directory path. For example, \code{MicrobData="C://...//microbiomeData.tsv"}.}

\item{CovData}{Covariates data matrix containing covariates and confounders with each row
per sample and each column per variable. Any categorical variable should be converted into dummy variables in this data matrix unless it can be treated as a continuous variable.
It should also contain an id variable to
be linked with the id variable in the microbiome data: \code{MicrobData}. This argument can take
directory path. For example, \code{CovData = "C://...//covariatesData.tsv"}.}

\item{linkIDname}{The common variable name of the id variable in both \code{MicrobData} and \code{CovData}. The two data sets will be merged by this id variable.}

\item{testCov}{Covariates that are of primary interest for testing and estimating the associations. It corresponds to $X_i$ in the equation. Default is \code{NULL} which means all covariates are \code{testCov}.}

\item{ctrlCov}{Potential confounders that will be adjusted in the model. It corresponds to $W_i$ in the equation. Default is \code{NULL} which means all covariates except those in \code{testCov} are adjusted as confounders.}

\item{testMany}{This takes logical value \code{TRUE} or \code{FALSE}. If \code{TRUE}, the \code{testCov} will contain all the variables in \code{CovData} provided \code{testCov} is set to be \code{NULL}. The default value is \code{TRUE} which does not do anything if \code{testCov} is not \code{NULL}.}

\item{ctrlMany}{This takes logical value \code{TRUE} or \code{FALSE}. If \code{TRUE}, all variables except \code{testCov} are considered as control covariates provided \code{ctrlCov} is set to be \code{NULL}. The default value is \code{FALSE}.}

\item{nRef}{The number of randomly picked reference taxa used in phase 1. Default number is \code{40}.}

\item{nRefMaxForEsti}{The maximum number of final reference taxa used in phase 2. The default is \code{2}.}

\item{refTaxa}{A vector of taxa or OTU or ASV names. These are reference taxa specified by the user to be used in phase 1. If the number of reference taxa is less than 'nRef', the algorithm will randomly pick extra reference taxa to make up 'nRef'. The default is \code{NULL} since the algorithm will pick reference taxa randomly.}

\item{adjust_method}{The adjusting method for p value adjustment. Default is "BY" for dependent FDR adjustment. It can take any adjustment method for p.adjust function in R.}

\item{fdrRate}{The false discovery rate for identifying taxa/OTU/ASV associated with \code{testCov}. Default is \code{0.15}.}

\item{paraJobs}{If \code{sequentialRun} is \code{FALSE}, this specifies the number of parallel jobs that will be registered to run the algorithm. If specified as \code{NULL}, it will automatically detect the cores to decide the number of parallel jobs. Default is \code{NULL}.}

\item{bootB}{Number of bootstrap samples for obtaining confidence interval of estimates in phase 2 for the high dimensional regression. The default is \code{500}.}

\item{standardize}{This takes a logical value \code{TRUE} or \code{FALSE}. If \code{TRUE}, the design matrix for X will be standardized in the analyses and the results. Default is \code{FALSE}.}

\item{sequentialRun}{This takes a logical value \code{TRUE} or \code{FALSE}. Default is \code{FALSE}. This argument could be useful for debug.}

\item{refReadsThresh}{The threshold of proportion of non-zero sequencing reads for choosing the reference taxon in phase 2. The default is \code{0.2} which means at least 20\% non-zero sequencing reads.}

\item{taxDropThresh}{The threshold of number of non-zero sequencing reads for each taxon to be dropped from the analysis. The default is \code{0} which means taxon without any sequencing reads will be dropped from the analysis.}

\item{SDThresh}{The threshold of standard deviations of sequencing reads for been chosen as the reference taxon in phase 2. The default is \code{0.05} which means the standard deviation of sequencing reads should be at least \code{0.05} in order to be chosen as reference taxon.}

\item{SDquantilThresh}{The threshold of the quantile of standard deviation of sequencing reads, above which could be selected as reference taxon. The default is \code{0}.}

\item{balanceCut}{The threshold of the proportion of non-zero sequencing reads in each group of a binary variable for choosing the final reference taxa in phase 2. The default number is \code{0.2} which means at least 20\% non-zero sequencing reads in each group are needed to be eligible for being chosen as a final reference taxon.}

\item{seed}{Random seed for reproducibility. Default is \code{1}. It can be set to be NULL to remove seeding.}
}
\value{
A list containing the estimation results.
\itemize{
\item \code{sig_results}: A list containing estimating results that are statistically significant.
\item \code{full_results}: A list containing all estimating results. NA denotes unestimable.
\item \code{covariatesData}: A dataset containing covariates and confounders used in the analyses.
}
}
\description{
Make inference on the association of microbiome with covariates
}
\details{
Most of the time, users just need to feed the first five inputs to the function: \code{MicrobData}, \code{CovData}, \code{linkIDname}, \code{testCov} and \code{ctrlCov}. All other inputs can just take their default values.
To model the association, the following equation is used:

\loadmathjax

\mjdeqn{\log(\mathcal{Y}_i^k)|\mathcal{Y}_i^k>0=\beta^{0k}+X_i^T\beta^k+W_i^T\gamma^k+Z_i^Tb_i+\epsilon_i^k,\hspace{0.2cm}k=1,...,K+1}{}
where
\itemize{
\item \mjeqn{\mathcal{Y}_i^k}{} is the AA of taxa \mjeqn{k}{} in subject \mjeqn{i}{} in the entire ecosystem.
\item \mjeqn{X_i}{} is the covariate matrix.
\item \mjeqn{W_i}{} is the confounder matrix.
\item \mjeqn{Z_i}{} is the design matrix for random effects.
\item \mjeqn{\beta^k}{} is the regression coefficients that will be estimated and tested with the \code{IFAA()} function.
}

The challenge in microbiome analysis is that \mjeqn{\mathcal{Y}_i^k}{} can not be observed. What is observed is its small proportion:
\mjeqn{Y_i^k=C_i\mathcal{Y}^k_i}{}, where \mjeqn{C_i}{} is an unknown number between 0
and 1 that denote the observed proportion.

The IFAA method can successfully addressed this challenge. The \code{IFAA()} will estimate the parameter
\mjeqn{\beta^k}{} and their 95\% confidence intervals. High-dimensional \mjeqn{X_i}{} is handled by
regularization.
}
\examples{
data(dataM)
dim(dataM)
dataM[1:5, 1:8]
data(dataC)
dim(dataC)
dataC[1:5, ]
\donttest{
results <- IFAA(MicrobData = dataM,
                CovData = dataC,
                linkIDname = "id",
                testCov = c("v1", "v2"),
                ctrlCov = c("v3"),
                fdrRate = 0.15)

}



}
\references{
Li et al.(2021) IFAA: Robust association identification and Inference For Absolute Abundance in microbiome analyses. Journal of the American Statistical Association

Zhang CH (2010) Nearly unbiased variable selection under minimax concave penalty. Annals of Statistics. 38(2):894-942.

Liu et al.(2020) A bootstrap lasso + partial ridge method to construct confidence intervals for parameters in high-dimensional sparse linear models. Statistica Sinica
}
