% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addScaleBar.R
\name{addScaleBar}
\alias{addScaleBar}
\title{Image Scale Bar Incrustation}
\usage{
addScaleBar(
  image,
  size,
  style = c("dash", "line")[1],
  color = "white",
  res = 96,
  xoff = 0,
  yoff = 0
)
}
\arguments{
\item{image}{a [0,1] image.}

\item{size}{positive integer. Scale's bar size in micro-meter. Default is '7'.\cr
This parameter can't be lesser than 6px and higher than image width + scale text.}

\item{style}{a character string. Scale's bar style, either 'dash' or 'line'. Default is 'dash'.}

\item{color}{a character string. color of the scale. Default is 'white'.}

\item{res}{positive integer. Resolution in ppi of 'image'. Default is '96'.}

\item{xoff}{positive integer. x offset in image to draw scale, starting from bottom left corner.}

\item{yoff}{positive integer. y offset in image to draw scale, starting from bottom left corner.}
}
\value{
an image with scale added to the bottom left corner.
}
\description{
Adds scale bar to image
}
\keyword{internal}
