% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectResize.R
\name{objectResize}
\alias{objectResize}
\title{Object Resizing}
\usage{
objectResize(
  mat,
  size = c(0, 0),
  add_noise = TRUE,
  random_seed = NULL,
  bg = 0,
  sd = 0
)
}
\arguments{
\item{mat}{a numeric matrix.}

\item{size}{a length 2 integer vector of final dimensions of the image, height 1st and width 2nd. Default is c(0,0) for no change.}

\item{add_noise}{if TRUE adds normal noise when size is larger than mat dimensions using rnorm(), from \pkg{Rcpp}. Default is TRUE.}

\item{random_seed}{a list of elements to pass to \link[base]{set.seed} or a single value, interpreted as an integer, or NULL to be used when 'add_noise' is set to TRUE. Default is NULL.
Note that NA_integer_ or list(seed = NA_integer_) can be used to not call \link[base]{set.seed} at all.}

\item{bg}{mean value of the background added if add_noise is TRUE. Default is 0.}

\item{sd}{standard deviation of the background added if add_noise is TRUE. Default is 0.}
}
\value{
a resized matrix with padding background if desired size is larger than original mat dimensions.
}
\description{
Resizes mat to new dimensions.
}
\keyword{internal}
