% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILS.R
\docType{data}
\name{IDT}
\alias{IDT}
\title{Dataset composed of the initial decomposition temperature (IDT) of different samples of Calcium Oxalate, obtained by 7 different laboratories}
\format{Dataframe of dimension 105 x 44. The first column corresponds to IDT variable, the second (Sample) is the replicate number,
 the third is the tested material (Material), and fourth is the laboratory.}
\description{
Initial decomposition temperature (IDT) is a parameter defined by temperature at which a material loss 5\% of its weight
when it is heated using a constant rate. One hundred and five calcium oxalate samples were tested by thermogravimetric analysis (TG),
obtaining 105 TG curves from which the IDT is extracted. Summarizing, IDT dataset is composed of the IDT values of
calcium oxalate obtained by 7 different laboratories that analyze 15 oxalate samples each one.:
Laboratory 1 uses a simultaneous thermal analyzer (STA) with an old calibration program, Laboratory 2 to Laboratory 4 use a SDT simultaneous analyzer,
Laboratory 6 utilizes a SDT simultaneous analyzer with an old calibration, and Laboratory 7 uses a SDT simultaneous analyzer with a biased calibration
(2 degrees Celsius shifted from the zinc melting point).
}
\examples{
library(ILS)
data(IDT)
summary(IDT)
attach(IDT)
str(IDT)
table(Sample,Run,Laboratory)
table(Laboratory,Run)
st <- with(IDT, tapply(IDT, list(Run,Laboratory), mean))
st
}
\references{
\describe{
  \item{}{Naya, S., Tarrio-Saavedra. J., Lopez- Beceiro, J., Francisco Fernandez, M., Flores, M. and  Artiaga, R. (2014),
  "Statistical functional approach for interlaboratory studies with thermal data". Journal of Thermal Analysis and Calorimetry, 118,1229-1243.}
}
}
