% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spss.syntax.R
\name{spss.syntax}
\alias{spss.syntax}
\title{'SPSS' merge syntax}
\usage{
spss.syntax(filelist, name, outputdir, zsav = TRUE, SPSSlimit = 50)
}
\arguments{
\item{filelist}{a character vector with the list of files to be merged.}

\item{name}{a string with the name of the merged file (without any
extension).}

\item{outputdir}{the directory where the \code{.sps} file and the
merged file will be saved.}

\item{zsav}{a logical value indicating if the the merged file should
be compressed with zsav. Default is \code{TRUE}.}

\item{SPSSlimit}{a numerical value indicating the limit of files per command
of 'SPSS', typically 50.}
}
\value{
Saves an \code{.sps} file with the 'SPSS' syntax for merging the
desired files.
}
\description{
Produces and saves an 'SPSS' merge syntax given a list of files.
}
\examples{

# For example, after downloading 'RLII' 1991 G4 data:

# Downloading 'RLII' 1991 and unzipping files
ILSAdownload(study = "RLII", year = 1991, outputdir = tempdir(), unzip = TRUE, agreeLicense = TRUE)

# Path were raw 'SPSS' files are
input <- file.path(tempdir(),"RLII1991_IDB_SPSS/Data")

# Path were merged files will be saved
output <- tempdir()

# List of ASCt1 files to be merged
files <- list.files(path = input, pattern = "ASC.+t1")

# Create 'SPSS' syntax
spss.syntax(filelist = files, name = "ASCt1", outputdir = output, zsav = TRUE)

}
