% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loocv_thresh_gam.R
\name{loocv_thresh_gam}
\alias{loocv_thresh_gam}
\title{Leave-One-Out Cross-Validation (LOOCV) procedure for (threshold-)GAMs}
\usage{
loocv_thresh_gam(model, ind_vec, press_vec, t_var_vec, name_t_var, k, a, b,
  time)
}
\arguments{
\item{model}{A single GAM object from the model tibble needed to extract
the family and the link function.}

\item{ind_vec}{A vector with the IND training observations (including or excluding
defined outliers).}

\item{press_vec}{A vector with the training observations (including or excluding
defined outliers) of pressure 1 (i.e. the original significant pressure in the
GAM(M)).}

\item{name_t_var}{The name of the threshold variable (pressure 2). t_var will be
named after this string in the model formula.}

\item{k}{Choice of knots (for the smoothing function \code{\link{s}}); the
default is 4 to avoid over-parameterization.}

\item{a}{The lower quantile value of the selected threshold variable, which
the estimated threshold is not allowed to exceed; the default is 0.2.}

\item{b}{The upper quantile value of the selected threshold variable, which
the estimated threshold is not allowed to exceed; the default is 0.8.}

\item{time}{A vector containing the actual time series.}
}
\value{
The function returns a list with the following 2 sublists:
\describe{
  \item{\code{result}}{logical; if TRUE, at least one thresh_gam
             performs better than its corresponding gam based on LOOCV value.}
  \item{\code{error}}{A string capturing potential error messages that
             occurred as side effects when fitting the threshold GAM for the
             LOOCV.}
}
}
\description{
\code{loocv_thresh_gam} applies a LOOCV on a threshold-GAM and its corresponding GAM and
returns TRUE if the threshold-GAM has a lower estimate, else FALSE (see for more infos on
the LOOCV procedure the details section in \code{\link{test_interaction}}).
}
\examples{
# Using the first model in the Baltic Sea demo data
loocv_thresh_gam(model = model_gam_ex$model[[1]],
  ind_vec = ind_init_ex$ind_train[[1]],
  press_vec = ind_init_ex$press_train[[1]],
  t_var_vec = ind_init_ex$press_train[[2]],
  name_t_var = "Swin",
  k = 4, a = 0.2, b = 0.8,
  time = ind_init_ex$time_train[[1]])
}
\seealso{
\code{\link{thresh_gam}} which creates a threshold-GAM object and
\code{\link{test_interaction}} which applies thresh_gam and loocv_thresh_gam
}
\keyword{internal}
