% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx_deriv.R
\name{approx_deriv}
\alias{approx_deriv}
\title{Alternative method for confidence interval approximations of derivatives}
\usage{
approx_deriv(init_tbl, mod_tbl, ci_prop_se)
}
\arguments{
\item{init_tbl}{The output tibble of the \code{\link{ind_init}} function.}

\item{mod_tbl}{A model output tibble from \code{\link{model_gam}},
\code{\link{select_model}} or \code{\link{merge_models}} representing the
best model for each IND~pressure pair.}

\item{ci_prop_se}{A conversion factor for approximating derivative CIs in the
`approx_method`; it is multiplied with the ratio between s.e. and mean fitted
values of the smoothing curve to represent some level of uncertainty around the
slope proportional to the uncertainty in the smoothing curve. Default is 25,
which is a compromise representing fairly well the results obtained for the GAMs
from the conditional bootstrap.}
}
\value{
The function returns the input model tibble with the following 4 columns added
\describe{
  \item{\code{press_seq}}{A list-column with sequences of 100 evenly spaced pressure
             values (with the length of the time series).}
  \item{\code{deriv1}}{A list-column with the first derivatives of the indicator
             responses averaged across all bootstraps (for the 100 equally spaced
             pressure values).}
  \item{\code{deriv1_ci_up}}{A list-column with the upper confidence limit of the
             bootstrapped first derivatives(for the 100 equally spaced
             pressure values).}
  \item{\code{deriv1_ci_low}}{A list-column with the lower confidence limit of the
             bootstrapped first derivatives(for the 100 equally spaced
             pressure values).}
}
}
\description{
\code{approx_deriv} implements a crude approximation for the uncertainty
around the first derivatives. It should be used complementary to the
conditional bootstrap, if problems with GAMM fittings occur
(see \code{\link{calc_deriv}}).
}
\details{
In this approach derivatives are calculated
for the original smoother and some level of uncertainty (not exactly the
confidence intervals) is estimated based on the standard error (s.e.)
of the smoother. The same proportion of error (estimated as the ratio
s.e./fitted mean) is adopted for the maximal slope of the derivative and
then kept constant across the entire curve. As this results in much smaller
uncertainty ranges, a conversion (or multiplication) factor is implemented
to allow modifications of the error proportion. The default of 25 is a
compromise representing fairly well the results obtained for the GAMs
from the conditional bootstrap.
}
\examples{
# Using some models of the Baltic Sea demo data
init_tbl <- ind_init_ex[ind_init_ex$id \%in\% c(5,9,75), ]
mod_tbl <- merge_models_ex[merge_models_ex$id  \%in\% c(5,9,75), ]
deriv_tbl <- approx_deriv(init_tbl, mod_tbl, ci_prop_se = 25)
}
\seealso{
the wrapper function \code{\link{calc_deriv}}
}
