% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_classes.R, R/rgeneric.R
\docType{class}
\name{rgeneric-class}
\alias{rgeneric-class}
\alias{rgeneric}
\alias{rgeneric.default}
\alias{rgeneric.rgeneric}
\alias{rgeneric.inla.rgeneric}
\alias{graph.rgeneric}
\alias{prec.rgeneric}
\alias{initial.rgeneric}
\alias{mu.rgeneric}
\alias{prior.rgeneric}
\title{Organize data for the latent GMRF R interface for \code{INLA}.}
\usage{
rgeneric(model, debug = FALSE, compile = TRUE, optimize = TRUE, ...)

\method{rgeneric}{default}(model, debug = FALSE, compile = TRUE, optimize = TRUE, ...)

\method{rgeneric}{rgeneric}(model, ...)

\method{rgeneric}{inla.rgeneric}(model, ...)

\method{graph}{rgeneric}(model, ...)

\method{prec}{rgeneric}(model, ...)

\method{initial}{rgeneric}(model)

\method{mu}{rgeneric}(model, theta)

\method{prior}{rgeneric}(model, theta)
}
\arguments{
\item{model}{a \code{rgeneric} model object}

\item{debug}{logical indicating debug state.}

\item{compile}{logical indicating to compile the model.}

\item{optimize}{logical indicating if only the elements
of the precision matrix are returned.}

\item{...}{additional parameter such as 'theta'
If 'theta' is not supplied, initial will be taken.}

\item{theta}{the parameter.}
}
\value{
\code{rgeneric}/ \code{inla.rgeneric} object.
}
\description{
Organize data for the latent GMRF R interface for \code{INLA}.

The rgeneric default method.
}
\section{Functions}{
\itemize{
\item \code{rgeneric(rgeneric)}: Returns the model object unchanged.

\item \code{rgeneric(inla.rgeneric)}: Converts a regular \code{inla.rgeneric} object to \code{rgeneric}.

\item \code{graph(rgeneric)}: The graph method for 'rgeneric'

\item \code{prec(rgeneric)}: The precision method for an \code{rgeneric} object.

\item \code{initial(rgeneric)}: The initial method for 'rgeneric'

\item \code{mu(rgeneric)}: The mu method for 'rgeneric'

\item \code{prior(rgeneric)}: The prior metho for 'rgeneric'

}}
