% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IQRoutliers.R
\name{IQRoutliers}
\alias{IQRoutliers}
\title{Computes outliers}
\usage{
IQRoutliers(date, value, level = 3, window = 11, exclude = NULL)
}
\arguments{
\item{date}{vector with dates}

\item{value}{vector with data values}

\item{level}{number of IQRs to be added to percentile 75 and subtracted to percentile 25 to
determinate the tolerance interval. Values outside this interval, will be declared as outliers.}

\item{window}{number of days to be considered (including the target)}

\item{exclude}{if it is not null, the code will exclude this value from the analysis (i.e., good to exclude 0 for precipitation)}
}
\value{
positions which do not pass this QC test
}
\description{
This function computes outliers centralized around a day, using a number of days around it
}
\examples{
#Extract the ECA&D data file from the example data folder
path2inptfl<-system.file("extdata", "TX_SOUID132734.txt", package = "INQC")
#Read the data file
date<-readecad(input=path2inptfl,missing= -9999)[,3]
value<-readecad(input=path2inptfl,missing= -9999)[,4]
#Find all suspicious positions in the time series
IQRoutliers(date,value,level=3,window=11,exclude=NULL)
}
