% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roundprecip.R
\name{roundprecip}
\alias{roundprecip}
\title{Rounding in precipitation data}
\usage{
roundprecip(y, blocksize = 20, exclude = 0)
}
\arguments{
\item{y}{two columns with date and data}

\item{blocksize}{maximum number of repeated values with the same decimal}

\item{exclude}{value to be excluded (zero for precipitation)}
}
\value{
list of positions which do not pass this QC test. If all positions pass the test, returns NULL
}
\description{
This function splits data by month and looks if a decimal value is repeated too many times
}
\examples{
#Extract the ECA&D data file from the example data folder
path2inptfl<-system.file("extdata", "RR_SOUID132730.txt", package = "INQC")
#Read the data file
y<-readecad(input=path2inptfl,missing= -9999)[,3:4]
#Find all suspicious positions in the precipitation time series
roundprecip(y,blocksize=20,exclude=0) 
}
