% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/itemfit.R
\name{x2_itemf}
\alias{x2_itemf}
\title{X2 Statistic}
\usage{
x2_itemf(model, z, patterns, pval.sim, G, FUN, B = NULL)
}
\arguments{
\item{model}{type of model ( "1PL", 2PL", "3PL" )}

\item{z}{list of estimations of the parameters of the items (discrimination,difficulty, guessing)}

\item{patterns}{matrix of patterns response, the frequency of each pattern and the latent traits}

\item{pval.sim}{if TRUE, simulates a p-value using bootstrap}

\item{G}{number of groups}

\item{FUN}{function to calculate the frecuency expected in the each group(mean, median,..)}

\item{B}{number of iterations bootstrap, if "NULL" B=100}
}
\value{
X2 Statistic y p-value
}
\description{
calculates the X2 values from Steven P. Reise
}
\examples{
#Simulates a test and returns a list:
test=simulateTest()

#the simulated data:
datos=test$test

#model:
mod=irtpp(dataset = datos,model = "3PL")

#latent trait:
zz = parameter.matrix(mod$z)
p_mat=mod$prob_mat
traits=individual.traits(model="3PL",method = "EAP",dataset = datos,itempars = zz,
probability_matrix=p_mat)

#X2-Statistic
x2_itemf(model = "3PL",z = mod$z,patterns = traits,pval.sim = TRUE,G = 10,FUN = median,B=4)
}
\author{
SICS Research, National University of Colombia \email{ammontenegrod@unal.edu.co}
}
\references{
Steven P. Reise (1990). A Comparison of item-and person-fit Methods of Assesing Model-Data fit in IRT \emph{University of Minnesota}.
}
\seealso{
\code{\link{z3_personf}}, \code{\link{plotenvelope}}
}

