% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.extra.fill_dates.R
\name{ISRaD.extra.fill_dates}
\alias{ISRaD.extra.fill_dates}
\title{ISRaD.extra.fill_dates}
\usage{
ISRaD.extra.fill_dates(database)
}
\arguments{
\item{database}{ISRaD dataset object.}
}
\value{
ISRaD_data object with filled frc_obs_date_y and inc_obs_date_y fields.
}
\description{
Fills frc_obs_date_y and inc_obs_date_y columns from lyr_obs_date_y if not reported.
}
\details{
QAQC does not require frc_obs_date_y or inc_obs_date_y fields to be filled in. Therefore it is recommended to run this function prior to running the functions ISRaD.extra.fill_14c, ISRaD.extra.fill_fm, and ISRaD.extra.delta_delta, which require xxx_obs_date_y data.
}
\examples{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
# Fill dates
database.x <- ISRaD.extra.fill_dates(database)
# Fraction table now has lyr_obs_date_y values in frc_obs_date_y field
}
