% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_IVDML.R
\name{se}
\alias{se}
\title{Compute Standard Error for the Treatment Effect Estimate in an IVDML Object}
\usage{
se(object, iv_method, a = NULL, A = NULL, kernel_name = NULL, bandwidth = NULL)
}
\arguments{
\item{object}{An object of class \code{IVDML}, produced by the \code{\link[=fit_IVDML]{fit_IVDML()}} function.}

\item{iv_method}{Character. The instrumental variable estimation method to use. Must be one of the methods specified in the fitted object.}

\item{a}{Numeric (optional). A specific value of \code{A} at which to evaluate the standard error of the heterogeneous treatment effect. If \code{NULL}, the function returns the standard error of the homogeneous treatment effect.}

\item{A}{Numeric vector (optional). The variable with respect to which treatment effect heterogeneity is considered. If \code{NULL}, the function assumes the \code{A} used in model fitting.}

\item{kernel_name}{Character (optional). The name of the kernel function to use for smoothing (if a heterogeneous treatment effect is estimated). Must be one of "boxcar", "gaussian", "epanechnikov", or "tricube".}

\item{bandwidth}{Numeric (optional). The bandwidth for the kernel smoothing (if a heterogeneous treatment effect is estimated).}
}
\value{
A numeric value representing the estimated standard error of the treatment effect estimate. If \code{a} is not specified, the function returns the standard error of the homogeneous treatment effect. If \code{a} is specified, it returns the standard error of the heterogeneous treatment effect estimate at \eqn{A = a}.
}
\description{
This function calculates the standard error of the estimated (potentially heterogeneous) treatment effect from a fitted \code{IVDML} object (output of \code{\link[=fit_IVDML]{fit_IVDML()}}).
}
\examples{
set.seed(1)
Z <- rnorm(100)
X <- Z + rnorm(100)
H <- rnorm(100)
D <- Z^2 + sin(X) + H + rnorm(100)
A <- X
Y <- tanh(A) * D + cos(X) - H + rnorm(100)
fit <- fit_IVDML(Y = Y, D = D, Z = Z, X = X, ml_method = "gam")
se(fit, iv_method = "mlIV")
se(fit, iv_method = "mlIV", a = 0, A = A, kernel_name = "boxcar", bandwidth = 0.2)

}
