% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.BIM.R
\name{predict.BIM}
\alias{predict.BIM}
\title{predict.BIM}
\usage{
\method{predict}{BIM}(object, xx, yy, newx, type = "both", ...)
}
\arguments{
\item{object}{result of BIM algorithm}

\item{xx}{model matrix of explanatory variables}

\item{yy}{label vector}

\item{newx}{test data}

\item{type}{the form of final output}

\item{...}{further arguments passed to or from other methods}
}
\value{
\item{response}{preded probabilities for xx}

\item{class}{preded class for xx}
}
\description{
This function performs the predion for BIM algorithm.
}
\examples{
data(park)
xx<-park$xx
yy<-park$yy
index<-c(1:floor(nrow(xx)*0.3))
train_xx<-xx[-index,]
test_xx<-xx[index,]
train_yy<-yy[-index]
test_yy<-yy[index]
re<-BIM(train_xx,train_yy)
res<-predict(re,train_xx,train_yy,test_xx,type="class")
print(res)

}
\keyword{BIM}
\keyword{predict}
