/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tchar;

import cern.colt.PersistentObject;
import cern.colt.buffer.tchar.CharBuffer3DConsumer;
import cern.colt.list.tchar.CharArrayList;

public class CharBuffer3D
extends PersistentObject
implements CharBuffer3DConsumer {
    private static final long serialVersionUID = 1L;
    protected CharBuffer3DConsumer target;
    protected char[] xElements;
    protected char[] yElements;
    protected char[] zElements;
    protected CharArrayList xList;
    protected CharArrayList yList;
    protected CharArrayList zList;
    protected int capacity;
    protected int size;

    public CharBuffer3D(CharBuffer3DConsumer charBuffer3DConsumer, int n) {
        this.target = charBuffer3DConsumer;
        this.capacity = n;
        this.xElements = new char[n];
        this.yElements = new char[n];
        this.zElements = new char[n];
        this.xList = new CharArrayList(this.xElements);
        this.yList = new CharArrayList(this.yElements);
        this.zList = new CharArrayList(this.zElements);
        this.size = 0;
    }

    public void add(char c, char c2, char c3) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = c;
        this.yElements[this.size] = c2;
        this.zElements[this.size++] = c3;
    }

    public void addAllOf(CharArrayList charArrayList, CharArrayList charArrayList2, CharArrayList charArrayList3) {
        int n = charArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(charArrayList, charArrayList2, charArrayList3);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

