/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DelegateDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperDComplexMatrix3D
extends DComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    protected DComplexMatrix3D content;

    public WrapperDComplexMatrix3D(DComplexMatrix3D dComplexMatrix3D) {
        if (dComplexMatrix3D != null) {
            this.setUp(dComplexMatrix3D.slices(), dComplexMatrix3D.rows(), dComplexMatrix3D.columns());
        }
        this.content = dComplexMatrix3D;
    }

    public Object elements() {
        return this.content.elements();
    }

    public void fft2Slices() {
        if (this.content instanceof DenseLargeDComplexMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix3D)this.content).fft2Slices();
            } else {
                DenseLargeDComplexMatrix3D denseLargeDComplexMatrix3D = (DenseLargeDComplexMatrix3D)this.copy();
                denseLargeDComplexMatrix3D.fft2Slices();
                this.assign(denseLargeDComplexMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fft3() {
        if (this.content instanceof DenseLargeDComplexMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix3D)this.content).fft3();
            } else {
                DenseLargeDComplexMatrix3D denseLargeDComplexMatrix3D = (DenseLargeDComplexMatrix3D)this.copy();
                denseLargeDComplexMatrix3D.fft3();
                this.assign(denseLargeDComplexMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft2Slices(boolean bl) {
        if (this.content instanceof DenseLargeDComplexMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix3D)this.content).ifft2Slices(bl);
            } else {
                DenseLargeDComplexMatrix3D denseLargeDComplexMatrix3D = (DenseLargeDComplexMatrix3D)this.copy();
                denseLargeDComplexMatrix3D.ifft2Slices(bl);
                this.assign(denseLargeDComplexMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft3(boolean bl) {
        if (this.content instanceof DenseLargeDComplexMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeDComplexMatrix3D)this.content).ifft3(bl);
            } else {
                DenseLargeDComplexMatrix3D denseLargeDComplexMatrix3D = (DenseLargeDComplexMatrix3D)this.copy();
                denseLargeDComplexMatrix3D.ifft3(bl);
                this.assign(denseLargeDComplexMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public synchronized double[] getQuick(int n, int n2, int n3) {
        return this.content.getQuick(n, n2, n3);
    }

    public DComplexMatrix3D like(int n, int n2, int n3) {
        return this.content.like(n, n2, n3);
    }

    public synchronized void setQuick(int n, int n2, int n3, double[] dArray) {
        this.content.setQuick(n, n2, n3, dArray);
    }

    public synchronized void setQuick(int n, int n2, int n3, double d, double d2) {
        this.content.setQuick(n, n2, n3, d, d2);
    }

    public DComplexMatrix1D vectorize() {
        DenseDComplexMatrix1D denseDComplexMatrix1D = new DenseDComplexMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            denseDComplexMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return denseDComplexMatrix1D;
    }

    public DComplexMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        return new DelegateDComplexMatrix2D(this, 2, n);
    }

    public DComplexMatrix3D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperDComplexMatrix3D wrapperDComplexMatrix3D = new WrapperDComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, n2, this.columns - 1 - n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, double[] dArray) {
                this.content.setQuick(n, n2, this.columns - 1 - n3, dArray);
            }

            public synchronized void setQuick(int n, int n2, int n3, double d, double d2) {
                this.content.setQuick(n, n2, this.columns - 1 - n3, d, d2);
            }

            public synchronized double[] get(int n, int n2, int n3) {
                return this.content.get(n, n2, this.columns - 1 - n3);
            }

            public synchronized void set(int n, int n2, int n3, double[] dArray) {
                this.content.set(n, n2, this.columns - 1 - n3, dArray);
            }

            public synchronized void set(int n, int n2, int n3, double d, double d2) {
                this.content.set(n, n2, this.columns - 1 - n3, d, d2);
            }
        };
        wrapperDComplexMatrix3D.isNoView = false;
        return wrapperDComplexMatrix3D;
    }

    public DComplexMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        return new DelegateDComplexMatrix2D(this, 0, n);
    }

    public DComplexMatrix3D viewSliceFlip() {
        if (this.slices == 0) {
            return this;
        }
        WrapperDComplexMatrix3D wrapperDComplexMatrix3D = new WrapperDComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n, int n2, int n3) {
                return this.content.getQuick(this.slices - 1 - n, n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, double[] dArray) {
                this.content.setQuick(this.slices - 1 - n, n2, n3, dArray);
            }

            public synchronized void setQuick(int n, int n2, int n3, double d, double d2) {
                this.content.setQuick(this.slices - 1 - n, n2, n3, d, d2);
            }

            public synchronized double[] get(int n, int n2, int n3) {
                return this.content.get(this.slices - 1 - n, n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, double[] dArray) {
                this.content.set(this.slices - 1 - n, n2, n3, dArray);
            }

            public synchronized void set(int n, int n2, int n3, double d, double d2) {
                this.content.set(this.slices - 1 - n, n2, n3, d, d2);
            }
        };
        wrapperDComplexMatrix3D.isNoView = false;
        return wrapperDComplexMatrix3D;
    }

    public DComplexMatrix3D viewDice(int n, int n2, int n3) {
        int n4 = 3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n == n2 || n == n3 || n2 == n3) {
            throw new IllegalArgumentException("Illegal Axes: " + n + ", " + n2 + ", " + n3);
        }
        WrapperDComplexMatrix3D wrapperDComplexMatrix3D = null;
        if (n == 0 && n2 == 1 && n3 == 2) {
            wrapperDComplexMatrix3D = new WrapperDComplexMatrix3D(this);
        } else if (n == 1 && n2 == 0 && n3 == 2) {
            wrapperDComplexMatrix3D = new WrapperDComplexMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized double[] getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n, n3);
                }

                public synchronized void setQuick(int n, int n2, int n3, double[] dArray) {
                    this.content.setQuick(n2, n, n3, dArray);
                }

                public synchronized void setQuick(int n, int n2, int n3, double d, double d2) {
                    this.content.setQuick(n2, n, n3, d, d2);
                }

                public synchronized double[] get(int n, int n2, int n3) {
                    return this.content.get(n2, n, n3);
                }

                public synchronized void set(int n, int n2, int n3, double[] dArray) {
                    this.content.set(n2, n, n3, dArray);
                }

                public synchronized void set(int n, int n2, int n3, double d, double d2) {
                    this.content.set(n2, n, n3, d, d2);
                }
            };
        } else if (n == 1 && n2 == 2 && n3 == 0) {
            wrapperDComplexMatrix3D = new WrapperDComplexMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized double[] getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n3, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, double[] dArray) {
                    this.content.setQuick(n2, n3, n, dArray);
                }

                public synchronized void setQuick(int n, int n2, int n3, double d, double d2) {
                    this.content.setQuick(n2, n3, n, d, d2);
                }

                public synchronized double[] get(int n, int n2, int n3) {
                    return this.content.get(n2, n3, n);
                }

                public synchronized void set(int n, int n2, int n3, double[] dArray) {
                    this.content.set(n2, n3, n, dArray);
                }

                public synchronized void set(int n, int n2, int n3, double d, double d2) {
                    this.content.set(n2, n3, n, d, d2);
                }
            };
        } else if (n == 2 && n2 == 1 && n3 == 0) {
            wrapperDComplexMatrix3D = new WrapperDComplexMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized double[] getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n2, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, double[] dArray) {
                    this.content.setQuick(n3, n2, n, dArray);
                }

                public synchronized void setQuick(int n, int n2, int n3, double d, double d2) {
                    this.content.setQuick(n3, n2, n, d, d2);
                }

                public synchronized double[] get(int n, int n2, int n3) {
                    return this.content.get(n3, n2, n);
                }

                public synchronized void set(int n, int n2, int n3, double[] dArray) {
                    this.content.set(n3, n2, n, dArray);
                }

                public synchronized void set(int n, int n2, int n3, double d, double d2) {
                    this.content.set(n3, n2, n, d, d2);
                }
            };
        } else if (n == 2 && n2 == 0 && n3 == 1) {
            wrapperDComplexMatrix3D = new WrapperDComplexMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized double[] getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n, n2);
                }

                public synchronized void setQuick(int n, int n2, int n3, double[] dArray) {
                    this.content.setQuick(n3, n, n2, dArray);
                }

                public synchronized void setQuick(int n, int n2, int n3, double d, double d2) {
                    this.content.setQuick(n3, n, n2, d, d2);
                }

                public synchronized double[] get(int n, int n2, int n3) {
                    return this.content.get(n3, n, n2);
                }

                public synchronized void set(int n, int n2, int n3, double[] dArray) {
                    this.content.set(n3, n, n2, dArray);
                }

                public synchronized void set(int n, int n2, int n3, double d, double d2) {
                    this.content.set(n3, n, n2, d, d2);
                }
            };
        }
        int[] nArray = this.shape();
        wrapperDComplexMatrix3D.slices = nArray[n];
        wrapperDComplexMatrix3D.rows = nArray[n2];
        wrapperDComplexMatrix3D.columns = nArray[n3];
        wrapperDComplexMatrix3D.isNoView = false;
        return wrapperDComplexMatrix3D;
    }

    public DComplexMatrix3D viewPart(final int n, final int n2, final int n3, int n4, int n5, int n6) {
        this.checkBox(n, n2, n3, n4, n5, n6);
        WrapperDComplexMatrix3D wrapperDComplexMatrix3D = new WrapperDComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void setQuick(int n4, int n22, int n32, double[] dArray) {
                this.content.setQuick(n + n4, n2 + n22, n3 + n32, dArray);
            }

            public synchronized void setQuick(int n4, int n22, int n32, double d, double d2) {
                this.content.setQuick(n + n4, n2 + n22, n3 + n32, d, d2);
            }

            public synchronized double[] get(int n4, int n22, int n32) {
                return this.content.get(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void set(int n4, int n22, int n32, double[] dArray) {
                this.content.set(n + n4, n2 + n22, n3 + n32, dArray);
            }

            public synchronized void set(int n4, int n22, int n32, double d, double d2) {
                this.content.set(n + n4, n2 + n22, n3 + n32, d, d2);
            }
        };
        wrapperDComplexMatrix3D.slices = n4;
        wrapperDComplexMatrix3D.rows = n5;
        wrapperDComplexMatrix3D.columns = n6;
        wrapperDComplexMatrix3D.isNoView = false;
        return wrapperDComplexMatrix3D;
    }

    public DComplexMatrix2D viewRow(int n) {
        this.checkRow(n);
        return new DelegateDComplexMatrix2D(this, 1, n);
    }

    public DComplexMatrix3D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperDComplexMatrix3D wrapperDComplexMatrix3D = new WrapperDComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, this.rows - 1 - n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, double[] dArray) {
                this.content.setQuick(n, this.rows - 1 - n2, n3, dArray);
            }

            public synchronized void setQuick(int n, int n2, int n3, double d, double d2) {
                this.content.setQuick(n, this.rows - 1 - n2, n3, d, d2);
            }

            public synchronized double[] get(int n, int n2, int n3) {
                return this.content.get(n, this.rows - 1 - n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, double[] dArray) {
                this.content.set(n, this.rows - 1 - n2, n3, dArray);
            }

            public synchronized void set(int n, int n2, int n3, double d, double d2) {
                this.content.set(n, this.rows - 1 - n2, n3, d, d2);
            }
        };
        wrapperDComplexMatrix3D.isNoView = false;
        return wrapperDComplexMatrix3D;
    }

    public DComplexMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        if (nArray == null) {
            nArray = new int[this.slices];
            n = this.slices;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray3[n] = n;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        final int[] nArray4 = nArray;
        final int[] nArray5 = nArray2;
        final int[] nArray6 = nArray3;
        WrapperDComplexMatrix3D wrapperDComplexMatrix3D = new WrapperDComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n, int n2, int n3) {
                return this.content.getQuick(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void setQuick(int n, int n2, int n3, double[] dArray) {
                this.content.setQuick(nArray4[n], nArray5[n2], nArray6[n3], dArray);
            }

            public synchronized void setQuick(int n, int n2, int n3, double d, double d2) {
                this.content.setQuick(nArray4[n], nArray5[n2], nArray6[n3], d, d2);
            }

            public synchronized double[] get(int n, int n2, int n3) {
                return this.content.get(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void set(int n, int n2, int n3, double[] dArray) {
                this.content.set(nArray4[n], nArray5[n2], nArray6[n3], dArray);
            }

            public synchronized void set(int n, int n2, int n3, double d, double d2) {
                this.content.set(nArray4[n], nArray5[n2], nArray6[n3], d, d2);
            }
        };
        wrapperDComplexMatrix3D.slices = nArray.length;
        wrapperDComplexMatrix3D.rows = nArray2.length;
        wrapperDComplexMatrix3D.columns = nArray3.length;
        wrapperDComplexMatrix3D.isNoView = false;
        return wrapperDComplexMatrix3D;
    }

    public DComplexMatrix3D viewStrides(final int n, final int n2, final int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperDComplexMatrix3D wrapperDComplexMatrix3D = new WrapperDComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double[] getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void setQuick(int n4, int n22, int n32, double[] dArray) {
                this.content.setQuick(n * n4, n2 * n22, n3 * n32, dArray);
            }

            public synchronized void setQuick(int n4, int n22, int n32, double d, double d2) {
                this.content.setQuick(n * n4, n2 * n22, n3 * n32, d, d2);
            }

            public synchronized double[] get(int n4, int n22, int n32) {
                return this.content.get(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void set(int n4, int n22, int n32, double[] dArray) {
                this.content.set(n * n4, n2 * n22, n3 * n32, dArray);
            }

            public synchronized void set(int n4, int n22, int n32, double d, double d2) {
                this.content.set(n * n4, n2 * n22, n3 * n32, d, d2);
            }
        };
        if (this.slices != 0) {
            wrapperDComplexMatrix3D.slices = (this.slices - 1) / n + 1;
        }
        if (this.rows != 0) {
            wrapperDComplexMatrix3D.rows = (this.rows - 1) / n2 + 1;
        }
        if (this.columns != 0) {
            wrapperDComplexMatrix3D.columns = (this.columns - 1) / n3 + 1;
        }
        wrapperDComplexMatrix3D.isNoView = false;
        return wrapperDComplexMatrix3D;
    }

    protected DComplexMatrix3D getContent() {
        return this.content;
    }

    public DComplexMatrix2D like2D(int n, int n2) {
        throw new InternalError();
    }

    protected DComplexMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    protected DComplexMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        throw new InternalError();
    }

    public DoubleMatrix3D getImaginaryPart() {
        final DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = new DenseLargeDoubleMatrix3D(this.slices, this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperDComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < WrapperDComplexMatrix3D.this.columns; ++k) {
                                    denseLargeDoubleMatrix3D.setQuick(i, j, k, WrapperDComplexMatrix3D.this.getQuick(i, j, k)[1]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        denseLargeDoubleMatrix3D.setQuick(i, j, k, this.getQuick(i, j, k)[1]);
                    }
                }
            }
        }
        return denseLargeDoubleMatrix3D;
    }

    public DoubleMatrix3D getRealPart() {
        final DenseLargeDoubleMatrix3D denseLargeDoubleMatrix3D = new DenseLargeDoubleMatrix3D(this.slices, this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperDComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < WrapperDComplexMatrix3D.this.columns; ++k) {
                                    denseLargeDoubleMatrix3D.setQuick(i, j, k, WrapperDComplexMatrix3D.this.getQuick(i, j, k)[0]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        denseLargeDoubleMatrix3D.setQuick(i, j, k, this.getQuick(i, j, k)[0]);
                    }
                }
            }
        }
        return denseLargeDoubleMatrix3D;
    }
}

