/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_dmperm;
import edu.emory.mathcs.csparsej.tfloat.Scs_ipvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_lsolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_lu;
import edu.emory.mathcs.csparsej.tfloat.Scs_sqr;
import edu.emory.mathcs.csparsej.tfloat.Scs_usolve;

public class SparseFloatLUDecomposition {
    private Scs_common.Scss S;
    private Scs_common.Scsn N;
    private FloatMatrix2D L;
    private FloatMatrix2D U;
    private boolean rcMatrix = false;
    private boolean isNonSingular = true;
    private int n;

    public SparseFloatLUDecomposition(FloatMatrix2D floatMatrix2D, int n, boolean bl) {
        Scs_common.Scsd scsd;
        Scs_common.Scs scs;
        FloatProperty.DEFAULT.checkSquare(floatMatrix2D);
        FloatProperty.DEFAULT.checkSparse(floatMatrix2D);
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("order must be a number between 0 and 3");
        }
        if (floatMatrix2D instanceof SparseRCFloatMatrix2D) {
            this.rcMatrix = true;
            scs = ((SparseRCFloatMatrix2D)floatMatrix2D).getColumnCompressed().elements();
        } else {
            scs = (Scs_common.Scs)floatMatrix2D.elements();
        }
        this.n = floatMatrix2D.rows();
        this.S = Scs_sqr.cs_sqr((int)n, (Scs_common.Scs)scs, (boolean)false);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_sqr()");
        }
        this.N = Scs_lu.cs_lu((Scs_common.Scs)scs, (Scs_common.Scss)this.S, (float)1.0f);
        if (this.N == null) {
            throw new IllegalArgumentException("Exception occured in cs_lu()");
        }
        if (bl && (scsd = Scs_dmperm.cs_dmperm((Scs_common.Scs)scs, (int)1)) != null && scsd.rr[3] < this.n) {
            this.isNonSingular = false;
        }
    }

    public float det() {
        if (!this.isNonsingular()) {
            return 0.0f;
        }
        int n = 1;
        for (int i = 0; i < this.n; ++i) {
            if (this.N.pinv[i] == i) continue;
            n = -n;
        }
        if (this.U == null) {
            this.U = new SparseCCFloatMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.U = ((SparseCCFloatMatrix2D)this.U).getRowCompressed();
            }
        }
        float f = n;
        for (int i = 0; i < this.n; ++i) {
            f *= this.U.getQuick(i, i);
        }
        return f;
    }

    public FloatMatrix2D getL() {
        if (this.L == null) {
            this.L = new SparseCCFloatMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCFloatMatrix2D)this.L).getRowCompressed();
            }
        }
        return this.L.copy();
    }

    public int[] getPivot() {
        if (this.N.pinv == null) {
            return null;
        }
        int[] nArray = new int[this.N.pinv.length];
        System.arraycopy(this.N.pinv, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public FloatMatrix2D getU() {
        if (this.U == null) {
            this.U = new SparseCCFloatMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.U = ((SparseCCFloatMatrix2D)this.U).getRowCompressed();
            }
        }
        return this.U.copy();
    }

    public Scs_common.Scss getSymbolicAnalysis() {
        Scs_common.Scss scss = new Scs_common.Scss();
        scss.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        scss.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        scss.lnz = this.S.lnz;
        scss.m2 = this.S.m2;
        scss.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        scss.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        scss.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        scss.unz = this.S.unz;
        return scss;
    }

    public boolean isNonsingular() {
        return this.isNonSingular;
    }

    public void solve(FloatMatrix1D floatMatrix1D) {
        if (floatMatrix1D.size() != (long)this.n) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("A is singular");
        }
        FloatProperty.DEFAULT.checkDense(floatMatrix1D);
        float[] fArray = new float[this.n];
        float[] fArray2 = floatMatrix1D.isView() ? (float[])floatMatrix1D.copy().elements() : (float[])floatMatrix1D.elements();
        Scs_ipvec.cs_ipvec((int[])this.N.pinv, (float[])fArray2, (float[])fArray, (int)this.n);
        Scs_lsolve.cs_lsolve((Scs_common.Scs)this.N.L, (float[])fArray);
        Scs_usolve.cs_usolve((Scs_common.Scs)this.N.U, (float[])fArray);
        Scs_ipvec.cs_ipvec((int[])this.S.q, (float[])fArray, (float[])fArray2, (int)this.n);
        if (floatMatrix1D.isView()) {
            floatMatrix1D.assign(fArray2);
        }
    }
}

