/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix3D;
import cern.colt.matrix.tlong.impl.SelectedDenseLongMatrix1D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultFirst;
import cern.jet.math.tlong.LongPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseLongMatrix1D
extends LongMatrix1D {
    private static final long serialVersionUID = 1L;
    protected long[] elements;

    public DenseLongMatrix1D(long[] lArray) {
        this(lArray.length);
        this.assign(lArray);
    }

    public DenseLongMatrix1D(int n) {
        this.setUp(n);
        this.elements = new long[n];
    }

    public DenseLongMatrix1D(int n, long[] lArray, int n2, int n3, boolean bl) {
        this.setUp(n, n2, n3);
        this.elements = lArray;
        this.isNoView = !bl;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction) {
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        long l = 0L;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int n = DenseLongMatrix1D.this.zero + n3 * DenseLongMatrix1D.this.stride;
                        long l = longFunction.apply(DenseLongMatrix1D.this.elements[n]);
                        for (int i = n3 + 1; i < n4; ++i) {
                            l = longLongFunction.apply(l, longFunction.apply(DenseLongMatrix1D.this.elements[n += DenseLongMatrix1D.this.stride]));
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longFunction.apply(this.elements[this.zero]);
            int n5 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                l = longLongFunction.apply(l, longFunction.apply(this.elements[n5 += this.stride]));
            }
        }
        return l;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction, IntArrayList intArrayList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        long l = 0L;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int n = DenseLongMatrix1D.this.zero + nArray[n4] * DenseLongMatrix1D.this.stride;
                        long l = longFunction.apply(DenseLongMatrix1D.this.elements[n]);
                        for (int i = n4 + 1; i < n5; ++i) {
                            n = DenseLongMatrix1D.this.zero + nArray[i] * DenseLongMatrix1D.this.stride;
                            long l2 = DenseLongMatrix1D.this.elements[n];
                            l = longLongFunction.apply(l, longFunction.apply(l2));
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            int n6 = this.zero + nArray[0] * this.stride;
            l = longFunction.apply(this.elements[n6]);
            for (int i = 1; i < n; ++i) {
                n6 = this.zero + nArray[i] * this.stride;
                long l2 = this.elements[n6];
                l = longLongFunction.apply(l, longFunction.apply(l2));
            }
        }
        return l;
    }

    public long aggregate(LongMatrix1D longMatrix1D, final LongLongFunction longLongFunction, final LongLongFunction longLongFunction2) {
        if (!(longMatrix1D instanceof DenseLongMatrix1D)) {
            return super.aggregate(longMatrix1D, longLongFunction, longLongFunction2);
        }
        this.checkSize(longMatrix1D);
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        final int n = (int)longMatrix1D.index(0);
        final int n2 = longMatrix1D.stride();
        final long[] lArray = (long[])longMatrix1D.elements();
        long l = 0L;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int n3 = DenseLongMatrix1D.this.zero + n5 * DenseLongMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        long l = longLongFunction2.apply(DenseLongMatrix1D.this.elements[n3], lArray[n22]);
                        for (int i = n5 + 1; i < n6; ++i) {
                            l = longLongFunction.apply(l, longLongFunction2.apply(DenseLongMatrix1D.this.elements[n3 += DenseLongMatrix1D.this.stride], lArray[n22 += n2]));
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longLongFunction2.apply(this.elements[this.zero], lArray[n]);
            int n7 = this.zero;
            int n8 = n;
            for (int i = 1; i < this.size; ++i) {
                l = longLongFunction.apply(l, longLongFunction2.apply(this.elements[n7 += this.stride], lArray[n8 += n2]));
            }
        }
        return l;
    }

    public LongMatrix1D assign(final LongFunction longFunction) {
        int n;
        long l;
        if (longFunction instanceof LongMult) {
            l = ((LongMult)longFunction).multiplicator;
            if (l == 1L) {
                return this;
            }
        } else {
            l = 0L;
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseLongMatrix1D.this.zero + n3 * DenseLongMatrix1D.this.stride;
                        if (longFunction instanceof LongMult) {
                            for (int i = n3; i < n4; ++i) {
                                int n2 = n;
                                DenseLongMatrix1D.this.elements[n2] = DenseLongMatrix1D.this.elements[n2] * l;
                                n += DenseLongMatrix1D.this.stride;
                            }
                        } else {
                            for (int i = n3; i < n4; ++i) {
                                DenseLongMatrix1D.this.elements[n] = longFunction.apply(DenseLongMatrix1D.this.elements[n]);
                                n += DenseLongMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero - this.stride;
            if (longFunction instanceof LongMult) {
                int n6 = this.size;
                while (--n6 >= 0) {
                    this.elements[n5 += this.stride] = this.elements[n5] * l;
                }
            } else {
                int n7 = this.size;
                while (--n7 >= 0) {
                    this.elements[n5 += this.stride] = longFunction.apply(this.elements[n5]);
                }
            }
        }
        return this;
    }

    public LongMatrix1D assign(final LongProcedure longProcedure, final LongFunction longFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseLongMatrix1D.this.zero + n3 * DenseLongMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            if (longProcedure.apply(DenseLongMatrix1D.this.elements[n])) {
                                DenseLongMatrix1D.this.elements[n] = longFunction.apply(DenseLongMatrix1D.this.elements[n]);
                            }
                            n += DenseLongMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (longProcedure.apply(this.elements[n5])) {
                    this.elements[n5] = longFunction.apply(this.elements[n5]);
                }
                n5 += this.stride;
            }
        }
        return this;
    }

    public LongMatrix1D assign(final LongProcedure longProcedure, final long l) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseLongMatrix1D.this.zero + n3 * DenseLongMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            if (longProcedure.apply(DenseLongMatrix1D.this.elements[n])) {
                                DenseLongMatrix1D.this.elements[n] = l;
                            }
                            n += DenseLongMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (longProcedure.apply(this.elements[n5])) {
                    this.elements[n5] = l;
                }
                n5 += this.stride;
            }
        }
        return this;
    }

    public LongMatrix1D assign(final long l) {
        final long[] lArray = this.elements;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseLongMatrix1D.this.zero + n3 * DenseLongMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            lArray[n] = l;
                            n += DenseLongMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                lArray[n5] = l;
                n5 += this.stride;
            }
        }
        return this;
    }

    public LongMatrix1D assign(final long[] lArray) {
        if (lArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + lArray.length + "size()=" + this.size());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(lArray, 0, this.elements, 0, lArray.length);
        } else if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseLongMatrix1D.this.zero + n3 * DenseLongMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            DenseLongMatrix1D.this.elements[n] = lArray[i];
                            n += DenseLongMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n5] = lArray[i];
                n5 += this.stride;
            }
        }
        return this;
    }

    public LongMatrix1D assign(final int[] nArray) {
        if (nArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + nArray.length + "size()=" + this.size());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = DenseLongMatrix1D.this.zero + n3 * DenseLongMatrix1D.this.stride;
                        for (int i = n3; i < n4; ++i) {
                            DenseLongMatrix1D.this.elements[n] = nArray[i];
                            n += DenseLongMatrix1D.this.stride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n5] = nArray[i];
                n5 += this.stride;
            }
        }
        return this;
    }

    public LongMatrix1D assign(LongMatrix1D longMatrix1D) {
        Object object;
        if (!(longMatrix1D instanceof DenseLongMatrix1D)) {
            super.assign(longMatrix1D);
            return this;
        }
        DenseLongMatrix1D denseLongMatrix1D = (DenseLongMatrix1D)longMatrix1D;
        if (denseLongMatrix1D == this) {
            return this;
        }
        this.checkSize(denseLongMatrix1D);
        if (this.isNoView && denseLongMatrix1D.isNoView) {
            System.arraycopy(denseLongMatrix1D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseLongMatrix1D)) {
            object = denseLongMatrix1D.copy();
            if (!(object instanceof DenseLongMatrix1D)) {
                super.assign(longMatrix1D);
                return this;
            }
            denseLongMatrix1D = (DenseLongMatrix1D)object;
        }
        object = denseLongMatrix1D.elements;
        if (this.elements == null || object == null) {
            throw new InternalError();
        }
        final int n = (int)denseLongMatrix1D.index(0);
        final int n2 = denseLongMatrix1D.stride;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable((long[])object){
                    final /* synthetic */ long[] val$elemsOther;
                    {
                        this.val$elemsOther = lArray;
                    }

                    public void run() {
                        int n3 = DenseLongMatrix1D.this.zero + n5 * DenseLongMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            DenseLongMatrix1D.this.elements[n3] = this.val$elemsOther[n22];
                            n3 += DenseLongMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                this.elements[n7] = (long)object[n8];
                n7 += this.stride;
                n8 += n2;
            }
        }
        return this;
    }

    public LongMatrix1D assign(LongMatrix1D longMatrix1D, final LongLongFunction longLongFunction) {
        if (!(longMatrix1D instanceof DenseLongMatrix1D)) {
            super.assign(longMatrix1D, longLongFunction);
            return this;
        }
        this.checkSize(longMatrix1D);
        final int n = (int)longMatrix1D.index(0);
        final int n2 = longMatrix1D.stride();
        final long[] lArray = (long[])longMatrix1D.elements();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = DenseLongMatrix1D.this.zero + n5 * DenseLongMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        if (longLongFunction == LongFunctions.mult) {
                            for (int i = n5; i < n6; ++i) {
                                int n3 = n9;
                                DenseLongMatrix1D.this.elements[n3] = DenseLongMatrix1D.this.elements[n3] * lArray[n22];
                                n9 += DenseLongMatrix1D.this.stride;
                                n22 += n2;
                            }
                        } else if (longLongFunction == LongFunctions.div) {
                            for (int i = n5; i < n6; ++i) {
                                int n4 = n9;
                                DenseLongMatrix1D.this.elements[n4] = DenseLongMatrix1D.this.elements[n4] / lArray[n22];
                                n9 += DenseLongMatrix1D.this.stride;
                                n22 += n2;
                            }
                        } else if (longLongFunction instanceof LongPlusMultFirst) {
                            long l = ((LongPlusMultFirst)longLongFunction).multiplicator;
                            if (l == 0L) {
                                for (int i = n5; i < n6; ++i) {
                                    DenseLongMatrix1D.this.elements[n9] = lArray[n22];
                                    n9 += DenseLongMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else if (l == 1L) {
                                for (int i = n5; i < n6; ++i) {
                                    int n52 = n9;
                                    DenseLongMatrix1D.this.elements[n52] = DenseLongMatrix1D.this.elements[n52] + lArray[n22];
                                    n9 += DenseLongMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else if (l == -1L) {
                                for (int i = n5; i < n6; ++i) {
                                    DenseLongMatrix1D.this.elements[n9] = lArray[n22] - DenseLongMatrix1D.this.elements[n9];
                                    n9 += DenseLongMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else {
                                for (int i = n5; i < n6; ++i) {
                                    DenseLongMatrix1D.this.elements[n9] = l * DenseLongMatrix1D.this.elements[n9] + lArray[n22];
                                    n9 += DenseLongMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            }
                        } else if (longLongFunction instanceof LongPlusMultSecond) {
                            long l = ((LongPlusMultSecond)longLongFunction).multiplicator;
                            if (l == 0L) {
                                return;
                            }
                            if (l == 1L) {
                                for (int i = n5; i < n6; ++i) {
                                    int n62 = n9;
                                    DenseLongMatrix1D.this.elements[n62] = DenseLongMatrix1D.this.elements[n62] + lArray[n22];
                                    n9 += DenseLongMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else if (l == -1L) {
                                for (int i = n5; i < n6; ++i) {
                                    int n7 = n9;
                                    DenseLongMatrix1D.this.elements[n7] = DenseLongMatrix1D.this.elements[n7] - lArray[n22];
                                    n9 += DenseLongMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            } else {
                                for (int i = n5; i < n6; ++i) {
                                    int n8 = n9;
                                    DenseLongMatrix1D.this.elements[n8] = DenseLongMatrix1D.this.elements[n8] + l * lArray[n22];
                                    n9 += DenseLongMatrix1D.this.stride;
                                    n22 += n2;
                                }
                            }
                        } else {
                            for (int i = n5; i < n6; ++i) {
                                DenseLongMatrix1D.this.elements[n9] = longLongFunction.apply(DenseLongMatrix1D.this.elements[n9], lArray[n22]);
                                n9 += DenseLongMatrix1D.this.stride;
                                n22 += n2;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            if (longLongFunction == LongFunctions.mult) {
                for (int i = 0; i < this.size; ++i) {
                    int n9 = n7;
                    this.elements[n9] = this.elements[n9] * lArray[n8];
                    n7 += this.stride;
                    n8 += n2;
                }
            } else if (longLongFunction == LongFunctions.div) {
                for (int i = 0; i < this.size; ++i) {
                    int n10 = n7;
                    this.elements[n10] = this.elements[n10] / lArray[n8];
                    n7 += this.stride;
                    n8 += n2;
                }
            } else if (longLongFunction instanceof LongPlusMultSecond) {
                long l = ((LongPlusMultSecond)longLongFunction).multiplicator;
                if (l == 0L) {
                    return this;
                }
                if (l == 1L) {
                    for (int i = 0; i < this.size; ++i) {
                        int n11 = n7;
                        this.elements[n11] = this.elements[n11] + lArray[n8];
                        n7 += this.stride;
                        n8 += n2;
                    }
                } else if (l == -1L) {
                    for (int i = 0; i < this.size; ++i) {
                        int n12 = n7;
                        this.elements[n12] = this.elements[n12] - lArray[n8];
                        n7 += this.stride;
                        n8 += n2;
                    }
                } else {
                    for (int i = 0; i < this.size; ++i) {
                        int n13 = n7;
                        this.elements[n13] = this.elements[n13] + l * lArray[n8];
                        n7 += this.stride;
                        n8 += n2;
                    }
                }
            } else {
                for (int i = 0; i < this.size; ++i) {
                    this.elements[n7] = longLongFunction.apply(this.elements[n7], lArray[n8]);
                    n7 += this.stride;
                    n8 += n2;
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = DenseLongMatrix1D.this.zero + n5 * DenseLongMatrix1D.this.stride;
                        for (int i = n5; i < n6; ++i) {
                            if (DenseLongMatrix1D.this.elements[n2] != 0L) {
                                ++n;
                            }
                            n2 += DenseLongMatrix1D.this.stride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n7 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                if (this.elements[n7] != 0L) {
                    ++n;
                }
                n7 += this.stride;
            }
        }
        return n;
    }

    public long[] elements() {
        return this.elements;
    }

    public void getNonZeros(LongArrayList longArrayList, LongArrayList longArrayList2) {
        longArrayList.clear();
        longArrayList2.clear();
        int n = this.zero;
        int n2 = this.size % 2;
        if (n2 == 1) {
            long l = this.elements[n];
            if (l != 0L) {
                longArrayList.add(0L);
                longArrayList2.add(l);
            }
            n += this.stride;
        }
        for (int i = n2; i < this.size; i += 2) {
            long l = this.elements[n];
            if (l != 0L) {
                longArrayList.add(i);
                longArrayList2.add(l);
            }
            if ((l = this.elements[n += this.stride]) != 0L) {
                longArrayList.add(i + 1);
                longArrayList2.add(l);
            }
            n += this.stride;
        }
    }

    public void getPositiveValues(LongArrayList longArrayList, LongArrayList longArrayList2) {
        longArrayList.clear();
        longArrayList2.clear();
        int n = this.zero;
        int n2 = this.size % 2;
        if (n2 == 1) {
            long l = this.elements[n];
            if (l > 0L) {
                longArrayList.add(0L);
                longArrayList2.add(l);
            }
            n += this.stride;
        }
        for (int i = n2; i < this.size; i += 2) {
            long l = this.elements[n];
            if (l > 0L) {
                longArrayList.add(i);
                longArrayList2.add(l);
            }
            if ((l = this.elements[n += this.stride]) > 0L) {
                longArrayList.add(i + 1);
                longArrayList2.add(l);
            }
            n += this.stride;
        }
    }

    public void getNegativeValues(LongArrayList longArrayList, LongArrayList longArrayList2) {
        longArrayList.clear();
        longArrayList2.clear();
        int n = this.zero;
        int n2 = this.size % 2;
        if (n2 == 1) {
            long l = this.elements[n];
            if (l < 0L) {
                longArrayList.add(0L);
                longArrayList2.add(l);
            }
            n += this.stride;
        }
        for (int i = n2; i < this.size; i += 2) {
            long l = this.elements[n];
            if (l < 0L) {
                longArrayList.add(i);
                longArrayList2.add(l);
            }
            if ((l = this.elements[n += this.stride]) < 0L) {
                longArrayList.add(i + 1);
                longArrayList2.add(l);
            }
            n += this.stride;
        }
    }

    public long[] getMaxLocation() {
        int n = 0;
        long l = 0L;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            long[][] lArray = new long[n2][2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n = DenseLongMatrix1D.this.zero + n5 * DenseLongMatrix1D.this.stride;
                        long l = DenseLongMatrix1D.this.elements[n];
                        int n2 = (n - DenseLongMatrix1D.this.zero) / DenseLongMatrix1D.this.stride;
                        for (int i = n5 + 1; i < n6; ++i) {
                            if (l >= DenseLongMatrix1D.this.elements[n += DenseLongMatrix1D.this.stride]) continue;
                            l = DenseLongMatrix1D.this.elements[n];
                            n2 = (n - DenseLongMatrix1D.this.zero) / DenseLongMatrix1D.this.stride;
                        }
                        return new long[]{l, n2};
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    lArray[n3] = (long[])futureArray[n3].get();
                }
                l = lArray[0][0];
                n = (int)lArray[0][1];
                for (n3 = 1; n3 < n2; ++n3) {
                    if (l >= lArray[n3][0]) continue;
                    l = lArray[n3][0];
                    n = (int)lArray[n3][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.elements[this.zero];
            n = 0;
            int n7 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                if (l >= this.elements[n7 += this.stride]) continue;
                l = this.elements[n7];
                n = (n7 - this.zero) / this.stride;
            }
        }
        return new long[]{l, n};
    }

    public long[] getMinLocation() {
        int n = 0;
        long l = 0L;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            long[][] lArray = new long[n2][2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n = DenseLongMatrix1D.this.zero + n5 * DenseLongMatrix1D.this.stride;
                        long l = DenseLongMatrix1D.this.elements[n];
                        int n2 = (n - DenseLongMatrix1D.this.zero) / DenseLongMatrix1D.this.stride;
                        for (int i = n5 + 1; i < n6; ++i) {
                            if (l <= DenseLongMatrix1D.this.elements[n += DenseLongMatrix1D.this.stride]) continue;
                            l = DenseLongMatrix1D.this.elements[n];
                            n2 = (n - DenseLongMatrix1D.this.zero) / DenseLongMatrix1D.this.stride;
                        }
                        return new long[]{l, n2};
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    lArray[n3] = (long[])futureArray[n3].get();
                }
                l = lArray[0][0];
                n = (int)lArray[0][1];
                for (n3 = 1; n3 < n2; ++n3) {
                    if (l <= lArray[n3][0]) continue;
                    l = lArray[n3][0];
                    n = (int)lArray[n3][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.elements[this.zero];
            n = 0;
            int n7 = this.zero;
            for (int i = 1; i < this.size; ++i) {
                if (l <= this.elements[n7 += this.stride]) continue;
                l = this.elements[n7];
                n = (n7 - this.zero) / this.stride;
            }
        }
        return new long[]{l, n};
    }

    public long getQuick(int n) {
        return this.elements[this.zero + n * this.stride];
    }

    public LongMatrix1D like(int n) {
        return new DenseLongMatrix1D(n);
    }

    public LongMatrix2D like2D(int n, int n2) {
        return new DenseLongMatrix2D(n, n2);
    }

    public LongMatrix2D reshape(final int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseLongMatrix2D denseLongMatrix2D = new DenseLongMatrix2D(n, n2);
        final long[] lArray = (long[])((LongMatrix2D)denseLongMatrix2D).elements();
        final int n3 = (int)((AbstractMatrix2D)denseLongMatrix2D).index(0, 0);
        final int n4 = denseLongMatrix2D.rowStride();
        final int n5 = denseLongMatrix2D.columnStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n6 = Math.min(n6, n2);
            Future[] futureArray = new Future[n6];
            int n7 = n2 / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = i * n7;
                final int n9 = i == n6 - 1 ? n2 : n8 + n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n8; i < n9; ++i) {
                            int n6 = n3 + i * n5;
                            int n2 = DenseLongMatrix1D.this.zero + i * n * DenseLongMatrix1D.this.stride;
                            for (int j = 0; j < n; ++j) {
                                lArray[n6] = DenseLongMatrix1D.this.elements[n2];
                                n6 += n4;
                                n2 += DenseLongMatrix1D.this.stride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = this.zero;
            for (int i = 0; i < n2; ++i) {
                int n11 = n3 + i * n5;
                for (int j = 0; j < n; ++j) {
                    lArray[n11] = this.elements[n10];
                    n11 += n4;
                    n10 += this.stride;
                }
            }
        }
        return denseLongMatrix2D;
    }

    public LongMatrix3D reshape(int n, final int n2, final int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseLongMatrix3D denseLongMatrix3D = new DenseLongMatrix3D(n, n2, n3);
        final long[] lArray = (long[])((LongMatrix3D)denseLongMatrix3D).elements();
        final int n4 = (int)((AbstractMatrix3D)denseLongMatrix3D).index(0, 0, 0);
        final int n5 = denseLongMatrix3D.sliceStride();
        final int n6 = denseLongMatrix3D.rowStride();
        final int n7 = denseLongMatrix3D.columnStride();
        int n8 = ConcurrencyUtils.getNumberOfThreads();
        if (n8 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n8 = Math.min(n8, n);
            Future[] futureArray = new Future[n8];
            int n9 = n / n8;
            for (int i = 0; i < n8; ++i) {
                final int n10 = i * n9;
                final int n11 = i == n8 - 1 ? n : n10 + n9;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n10; i < n11; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                int n = n4 + i * n5 + j * n7;
                                int n22 = DenseLongMatrix1D.this.zero + (i * n2 * n3 + j * n2) * DenseLongMatrix1D.this.stride;
                                for (int k = 0; k < n2; ++k) {
                                    lArray[n] = DenseLongMatrix1D.this.elements[n22];
                                    n += n6;
                                    n22 += DenseLongMatrix1D.this.stride;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n12 = this.zero;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n13 = n4 + i * n5 + j * n7;
                    for (int k = 0; k < n2; ++k) {
                        lArray[n13] = this.elements[n12];
                        n13 += n6;
                        n12 += this.stride;
                    }
                }
            }
        }
        return denseLongMatrix3D;
    }

    public void setQuick(int n, long l) {
        this.elements[this.zero + n * this.stride] = l;
    }

    public void swap(LongMatrix1D longMatrix1D) {
        DenseLongMatrix1D denseLongMatrix1D;
        if (!(longMatrix1D instanceof DenseLongMatrix1D)) {
            super.swap(longMatrix1D);
        }
        if ((denseLongMatrix1D = (DenseLongMatrix1D)longMatrix1D) == this) {
            return;
        }
        this.checkSize(denseLongMatrix1D);
        final long[] lArray = denseLongMatrix1D.elements;
        if (this.elements == null || lArray == null) {
            throw new InternalError();
        }
        final int n = (int)longMatrix1D.index(0);
        final int n2 = longMatrix1D.stride();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = this.size / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? this.size : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n3 = DenseLongMatrix1D.this.zero + n5 * DenseLongMatrix1D.this.stride;
                        int n22 = n + n5 * n2;
                        for (int i = n5; i < n6; ++i) {
                            long l = DenseLongMatrix1D.this.elements[n3];
                            DenseLongMatrix1D.this.elements[n3] = lArray[n22];
                            lArray[n22] = l;
                            n3 += DenseLongMatrix1D.this.stride;
                            n22 += n2;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = this.zero;
            int n8 = n;
            for (int i = 0; i < this.size; ++i) {
                long l = this.elements[n7];
                this.elements[n7] = lArray[n8];
                lArray[n8] = l;
                n7 += this.stride;
                n8 += n2;
            }
        }
    }

    public void toArray(long[] lArray) {
        if (lArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, lArray, 0, this.elements.length);
        } else {
            super.toArray(lArray);
        }
    }

    public long zDotProduct(LongMatrix1D longMatrix1D) {
        if (!(longMatrix1D instanceof DenseLongMatrix1D)) {
            return super.zDotProduct(longMatrix1D);
        }
        DenseLongMatrix1D denseLongMatrix1D = (DenseLongMatrix1D)longMatrix1D;
        final long[] lArray = denseLongMatrix1D.elements;
        int n = (int)this.index(0);
        int n2 = (int)denseLongMatrix1D.index(0);
        int n3 = denseLongMatrix1D.stride;
        if (this.elements == null || lArray == null) {
            throw new InternalError();
        }
        long l = 0L;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n5;
            final int n6 = n;
            final int n7 = n2;
            final int n8 = n3;
            n4 = Math.min(n4, this.size);
            Future[] futureArray = new Future[n4];
            Long[] longArray = new Long[n4];
            int n9 = this.size / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n10 = n5 * n9;
                final int n11 = n5 == n4 - 1 ? this.size : n10 + n9;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int n = n6 + n10 * DenseLongMatrix1D.this.stride;
                        int n2 = n7 + n10 * n8;
                        n -= DenseLongMatrix1D.this.stride;
                        n2 -= n8;
                        long l = 0L;
                        int n3 = n11 - n10;
                        int n4 = n3 / 4;
                        while (--n4 >= 0) {
                            int n5 = n + DenseLongMatrix1D.this.stride;
                            n = n5;
                            int n62 = n2 + n8;
                            n2 = n62;
                            int n72 = n + DenseLongMatrix1D.this.stride;
                            n = n72;
                            int n82 = n2 + n8;
                            n2 = n82;
                            n = n + DenseLongMatrix1D.this.stride;
                            n2 = n2 + n8;
                            l += DenseLongMatrix1D.this.elements[n5] * lArray[n62] + DenseLongMatrix1D.this.elements[n72] * lArray[n82] + DenseLongMatrix1D.this.elements[n] * lArray[n2] + DenseLongMatrix1D.this.elements[n += DenseLongMatrix1D.this.stride] * lArray[n2 += n8];
                        }
                        n4 = n3 % 4;
                        while (--n4 >= 0) {
                            l += DenseLongMatrix1D.this.elements[n += DenseLongMatrix1D.this.stride] * lArray[n2 += n8];
                        }
                        return l;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    longArray[n5] = (Long)futureArray[n5].get();
                }
                l = longArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    l += longArray[n5].longValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n -= this.stride;
            n2 -= n3;
            int n12 = this.size / 4;
            while (--n12 >= 0) {
                int n13 = n + this.stride;
                n = n13;
                int n14 = n2 + n3;
                n2 = n14;
                int n15 = n + this.stride;
                n = n15;
                int n16 = n2 + n3;
                n2 = n16;
                n = n + this.stride;
                n2 = n2 + n3;
                l += this.elements[n13] * lArray[n14] + this.elements[n15] * lArray[n16] + this.elements[n] * lArray[n2] + this.elements[n += this.stride] * lArray[n2 += n3];
            }
            n12 = this.size % 4;
            while (--n12 >= 0) {
                l += this.elements[n += this.stride] * lArray[n2 += n3];
            }
        }
        return l;
    }

    public long zDotProduct(LongMatrix1D longMatrix1D, int n, int n2) {
        if (!(longMatrix1D instanceof DenseLongMatrix1D)) {
            return super.zDotProduct(longMatrix1D, n, n2);
        }
        DenseLongMatrix1D denseLongMatrix1D = (DenseLongMatrix1D)longMatrix1D;
        int n3 = n + n2;
        if (n < 0 || n2 < 0) {
            return 0L;
        }
        if (this.size < n3) {
            n3 = this.size;
        }
        if (longMatrix1D.size() < (long)n3) {
            n3 = (int)longMatrix1D.size();
        }
        final long[] lArray = denseLongMatrix1D.elements;
        int n4 = (int)this.index(n);
        int n5 = (int)denseLongMatrix1D.index(n);
        int n6 = denseLongMatrix1D.stride;
        if (this.elements == null || lArray == null) {
            throw new InternalError();
        }
        long l = 0L;
        int n7 = ConcurrencyUtils.getNumberOfThreads();
        if (n7 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n8;
            final int n9 = n4;
            final int n10 = n5;
            final int n11 = n6;
            n7 = Math.min(n7, n2);
            Future[] futureArray = new Future[n7];
            Long[] longArray = new Long[n7];
            int n12 = n2 / n7;
            for (n8 = 0; n8 < n7; ++n8) {
                final int n13 = n8 * n12;
                final int n14 = n8 == n7 - 1 ? n2 : n13 + n12;
                futureArray[n8] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int n = n9 + n13 * DenseLongMatrix1D.this.stride;
                        int n2 = n10 + n13 * n11;
                        n -= DenseLongMatrix1D.this.stride;
                        n2 -= n11;
                        long l = 0L;
                        int n3 = n14 - n13;
                        int n4 = n3 / 4;
                        while (--n4 >= 0) {
                            int n5 = n + DenseLongMatrix1D.this.stride;
                            n = n5;
                            int n6 = n2 + n11;
                            n2 = n6;
                            int n7 = n + DenseLongMatrix1D.this.stride;
                            n = n7;
                            int n8 = n2 + n11;
                            n2 = n8;
                            n = n + DenseLongMatrix1D.this.stride;
                            n2 = n2 + n11;
                            l += DenseLongMatrix1D.this.elements[n5] * lArray[n6] + DenseLongMatrix1D.this.elements[n7] * lArray[n8] + DenseLongMatrix1D.this.elements[n] * lArray[n2] + DenseLongMatrix1D.this.elements[n += DenseLongMatrix1D.this.stride] * lArray[n2 += n11];
                        }
                        n4 = n3 % 4;
                        while (--n4 >= 0) {
                            l += DenseLongMatrix1D.this.elements[n += DenseLongMatrix1D.this.stride] * lArray[n2 += n11];
                        }
                        return l;
                    }
                });
            }
            try {
                for (n8 = 0; n8 < n7; ++n8) {
                    longArray[n8] = (Long)futureArray[n8].get();
                }
                l = longArray[0];
                for (n8 = 1; n8 < n7; ++n8) {
                    l += longArray[n8].longValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 -= this.stride;
            n5 -= n6;
            int n15 = n3 - n;
            int n16 = n15 / 4;
            while (--n16 >= 0) {
                int n17 = n4 + this.stride;
                n4 = n17;
                int n18 = n5 + n6;
                n5 = n18;
                int n19 = n4 + this.stride;
                n4 = n19;
                int n20 = n5 + n6;
                n5 = n20;
                n4 = n4 + this.stride;
                n5 = n5 + n6;
                l += this.elements[n17] * lArray[n18] + this.elements[n19] * lArray[n20] + this.elements[n4] * lArray[n5] + this.elements[n4 += this.stride] * lArray[n5 += n6];
            }
            n16 = n15 % 4;
            while (--n16 >= 0) {
                l += this.elements[n4 += this.stride] * lArray[n5 += n6];
            }
        }
        return l;
    }

    public long zSum() {
        long l = 0L;
        final long[] lArray = this.elements;
        if (lArray == null) {
            throw new InternalError();
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n2;
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            Long[] longArray = new Long[n];
            int n3 = this.size / n;
            for (n2 = 0; n2 < n; ++n2) {
                final int n4 = n2 * n3;
                final int n5 = n2 == n - 1 ? this.size : n4 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        int n = 0;
                        int n2 = DenseLongMatrix1D.this.zero + n4 * DenseLongMatrix1D.this.stride;
                        for (int i = n4; i < n5; ++i) {
                            n = (int)((long)n + lArray[n2]);
                            n2 += DenseLongMatrix1D.this.stride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    longArray[n2] = (Long)futureArray[n2].get();
                }
                l = longArray[0];
                for (n2 = 1; n2 < n; ++n2) {
                    l += longArray[n2].longValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n6 = this.zero;
            for (int i = 0; i < this.size; ++i) {
                l += lArray[n6];
                n6 += this.stride;
            }
        }
        return l;
    }

    protected int cardinality(int n) {
        int n2 = 0;
        int n3 = this.zero;
        long[] lArray = this.elements;
        int n4 = this.size;
        while (--n4 >= 0 && n2 < n) {
            if (lArray[n3] != 0L) {
                ++n2;
            }
            n3 += this.stride;
        }
        return n2;
    }

    protected boolean haveSharedCellsRaw(LongMatrix1D longMatrix1D) {
        if (longMatrix1D instanceof SelectedDenseLongMatrix1D) {
            SelectedDenseLongMatrix1D selectedDenseLongMatrix1D = (SelectedDenseLongMatrix1D)longMatrix1D;
            return this.elements == selectedDenseLongMatrix1D.elements;
        }
        if (longMatrix1D instanceof DenseLongMatrix1D) {
            DenseLongMatrix1D denseLongMatrix1D = (DenseLongMatrix1D)longMatrix1D;
            return this.elements == denseLongMatrix1D.elements;
        }
        return false;
    }

    public long index(int n) {
        return this.zero + n * this.stride;
    }

    protected LongMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseLongMatrix1D(this.elements, nArray);
    }
}

