/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;

public class WrapperDoubleMatrix1D
extends DoubleMatrix1D {
    private static final long serialVersionUID = 1L;
    protected DoubleMatrix1D content;

    public WrapperDoubleMatrix1D(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D != null) {
            this.setUp((int)doubleMatrix1D.size());
        }
        this.content = doubleMatrix1D;
    }

    protected DoubleMatrix1D getContent() {
        return this.content;
    }

    public synchronized double getQuick(int n) {
        return this.content.getQuick(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    public DoubleMatrix1D like(int n) {
        return this.content.like(n);
    }

    public DoubleMatrix2D like2D(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public DoubleMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public DoubleMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public synchronized void setQuick(int n, double d) {
        this.content.setQuick(n, d);
    }

    public DoubleMatrix1D viewFlip() {
        WrapperDoubleMatrix1D wrapperDoubleMatrix1D = new WrapperDoubleMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n) {
                return this.content.getQuick(this.size - 1 - n);
            }

            public synchronized void setQuick(int n, double d) {
                this.content.setQuick(this.size - 1 - n, d);
            }

            public synchronized double get(int n) {
                return this.content.get(this.size - 1 - n);
            }

            public synchronized void set(int n, double d) {
                this.content.set(this.size - 1 - n, d);
            }
        };
        return wrapperDoubleMatrix1D;
    }

    public DoubleMatrix1D viewPart(final int n, int n2) {
        this.checkRange(n, n2);
        WrapperDoubleMatrix1D wrapperDoubleMatrix1D = new WrapperDoubleMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n2) {
                return this.content.getQuick(n + n2);
            }

            public synchronized void setQuick(int n2, double d) {
                this.content.setQuick(n + n2, d);
            }

            public synchronized double get(int n2) {
                return this.content.get(n + n2);
            }

            public synchronized void set(int n2, double d) {
                this.content.set(n + n2, d);
            }
        };
        wrapperDoubleMatrix1D.size = n2;
        return wrapperDoubleMatrix1D;
    }

    public DoubleMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            int n = this.size;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        this.checkIndexes(nArray);
        final int[] nArray2 = nArray;
        WrapperDoubleMatrix1D wrapperDoubleMatrix1D = new WrapperDoubleMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n) {
                return this.content.getQuick(nArray2[n]);
            }

            public synchronized void setQuick(int n, double d) {
                this.content.setQuick(nArray2[n], d);
            }

            public synchronized double get(int n) {
                return this.content.get(nArray2[n]);
            }

            public synchronized void set(int n, double d) {
                this.content.set(nArray2[n], d);
            }
        };
        wrapperDoubleMatrix1D.size = nArray.length;
        return wrapperDoubleMatrix1D;
    }

    protected DoubleMatrix1D viewSelectionLike(int[] nArray) {
        throw new InternalError();
    }

    public DoubleMatrix1D viewStrides(final int n) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperDoubleMatrix1D wrapperDoubleMatrix1D = new WrapperDoubleMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized double getQuick(int n2) {
                return this.content.getQuick(n2 * n);
            }

            public synchronized void setQuick(int n2, double d) {
                this.content.setQuick(n2 * n, d);
            }

            public synchronized double get(int n2) {
                return this.content.get(n2 * n);
            }

            public synchronized void set(int n2, double d) {
                this.content.set(n2 * n, d);
            }
        };
        if (this.size != 0) {
            wrapperDoubleMatrix1D.size = (this.size - 1) / n + 1;
        }
        return wrapperDoubleMatrix1D;
    }
}

