% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindEstimates.R
\name{bindPrevalenceEstimates}
\alias{bindPrevalenceEstimates}
\title{Bind multiple prevalence estimates into a single set of estimates}
\usage{
bindPrevalenceEstimates(...)
}
\arguments{
\item{...}{Multiple prevalence estimates, generated from
\code{estimatePeriodPrevalence()} or \code{estimatePointPrevalence()}}
}
\value{
Bound prevalence estimates
}
\description{
Bind multiple prevalence estimates into a single set of estimates
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 10000)
cdm <- generateDenominatorCohortSet(
  cdm = cdm, name = "denominator"
)
prev1 <- estimatePeriodPrevalence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
prev2 <- estimatePointPrevalence(
  cdm = cdm,
  denominatorTable = "denominator",
  outcomeTable = "outcome"
)
prevCombined <- bindPrevalenceEstimates(prev1, prev2)
}
}
