% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geks.R
\name{GEKSIndex}
\alias{GEKSIndex}
\title{Compute a GEKS multilateral index}
\usage{
GEKSIndex(
  x,
  pvar,
  qvar,
  pervar,
  indexMethod = "tornqvist",
  prodID,
  sample = "matched",
  window = 13,
  splice = "mean",
  biasAdjust = FALSE
)
}
\arguments{
\item{x}{A dataframe containing price, quantity, a time period identifier
and a product identifier. It must have column names.}

\item{pvar}{A character string for the name of the price variable}

\item{qvar}{A character string for the name of the quantity variable}

\item{pervar}{A character string for the name of the time variable. This variable
must contain integers starting at period 1 and increasing in increments of 1 period.
There may be observations on multiple products for each time period.}

\item{indexMethod}{A character string to select the index number method. Valid index
number methods are fisher, tornqvist or tpd. The default is tornqvist.}

\item{prodID}{A character string for the name of the product identifier}

\item{sample}{A character string specifying whether matching is to be performed.
The default is to use matching.
If sample=matched then any products that are not present in comparison periods
are removed prior to estimating the index for those periods.}

\item{window}{An integer specifying the length of the window.}

\item{splice}{A character string specifying the splicing method. Valid methods are
window, movement, half, mean, fbew or fbmw. The default is mean. See details for important
considerations when using fbew and fbmw.}

\item{biasAdjust}{whether to adjust for bias in the coefficients of the bilateral TPD index.
The default is FALSE because making this adjustment will break transitivity of the
GEKS index.}
}
\description{
A function to calculate a GEKS multilateral price index
}
\details{
The splicing methods are used to update the price index when new data become
available without changing prior index values. The window, movement, half and mean splices
use the most recent index value as the base period, which is multiplied by a price movement
computed using new data. The fbew (Fixed Base Expanding Window) and fbmw (Fixed Base Moving
Window) use a fixed base onto which the price movement using new data is applied. The base
period is updated periodically. IndexNumR calculates which periods are the base periods using
\code{seq(from = 1, to = n, by = window - 1)}, so the data must be set up correctly and the
right window length chosen. For example, if you have monthly data and want December
of each year to be the base period, then the first period in the data must be December
and the window must be set to 13.
}
\examples{
# compute a GEKS mutlilateral index with mean splicing
GEKSIndex(CES_sigma_2, pvar = "prices", qvar = "quantities", pervar = "time",
prodID = "prodID", indexMethod = "tornqvist", window=11, splice = "mean")

# compute a GEKS multilateral index with window splicing and the Fisher index method
GEKSIndex(CES_sigma_2, pvar = "prices", qvar = "quantities", pervar = "time",
prodID = "prodID", indexMethod = "fisher", window=11, splice = "mean")

}
\references{
Ivancic, L., W.E. Diewert and K.J. Fox (2011), "Scanner Data,
Time Aggregation and the Construction of Price Indexes", Journal of
Econometrics 161, 24-35.
}
