% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-apply.R
\docType{methods}
\name{apply}
\alias{apply}
\alias{apply,IntervalMatrix-method}
\title{Apply functions over \code{IntervalMatrix} margins}
\usage{
\S4method{apply}{IntervalMatrix}(X, MARGIN, FUN)
}
\arguments{
\item{X}{a matrix of interval-valued data.}

\item{MARGIN}{a numeric value giving the direction which the function will be applied over.
\itemize{
\item \code{1}: the function will be applied by rows.
\item \code{2}: the function will be applied by columns.}}

\item{FUN}{the function to be applied.}
}
\value{
Returns the numeric vector or the list of interval-valued data obtained
by applying the selected function to margins of an interval-valued data matrix.
}
\description{
This function returns the numeric vector or the list of interval-valued data obtained
by applying a function to margins of an interval-valued data matrix.
}
\examples{
data <- matrix(c(0, 2, 0, 4, 1, 3, 3, 9), 2, 4, byrow = TRUE)
m <- IntervalMatrix(data)
apply(m, 1, mean)
apply(m, 2, mean)
apply(m, 1, var)
apply(m, 2, var)
}
\seealso{
Other IntervalMatrix-method: 
\code{\link{IntervalMatrix-class}},
\code{\link{IntervalMatrix}},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{show}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalMatrix-method}
