% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-cov.R
\docType{methods}
\name{cov}
\alias{cov}
\alias{cov,IntervalList,IntervalList-method}
\title{Calculate the covariance of two samples of \eqn{n} interval-valued data}
\usage{
\S4method{cov}{IntervalList,IntervalList}(x, y, theta = 1)
}
\arguments{
\item{x}{a list of interval-valued data.}

\item{y}{a list of interval-valued data with the same length as \code{x}.}

\item{theta}{a single positive numeric value. By default, \code{theta}=1.}
}
\value{
Returns the calculated covariance of two samples of \eqn{n} interval-valued data, i.e., a real number.
}
\description{
This function calculates the covariance of two samples of \eqn{n} interval-valued data.
}
\details{
Let \eqn{\mathcal{X}} and \eqn{\mathcal{Y}} be two interval-valued random sets
and let \eqn{\left((x_{1},y_{1}),(x_{2},y_{2}),\ldots,(x_{n},y_{n})\right)}
be a sample of \eqn{n} independent observations drawn from \eqn{\left(\mathcal{X},\mathcal{Y}\right)}.
Then, the sample covariance is defined as follows,
\deqn{s_{\mathcal{X}\mathcal{Y}}=s_{\mathrm{mid}~\mathcal{X}\mathrm{mid}~\mathcal{Y}}+\theta\cdot s_{\mathrm{spr}~\mathcal{X}\mathrm{spr}~\mathcal{Y}},}
where \eqn{\theta>0} and \deqn{s_{\mathrm{mid}~\mathcal{X}\mathrm{mid}~\mathcal{Y}}=\frac{1}{n}\sum_{i=1}^{n}(\mathrm{mid}~x_{i}-\mathrm{mid}~\overline{x})(\mathrm~{mid}~y_{i}-\mathrm{mid}~\overline{y}),}
with \eqn{\overline{x}} and \eqn{\overline{y}} being the sample Aumann means of the given random samples.
}
\examples{
list <- IntervalList(c(1, 3), c(2, 5))
cov(list, list)
var(list)
cov(list, list, 1/3)
var(list, 1/3)

list1 <- IntervalList(c(0, 3, 2, 5, 6), c(4, 5, 4, 8, 7))
list2 <- IntervalList(c(3, 0, 3, 1, 4), c(7, 4, 6, 2, 6))
cov(list1, list2)
cov(list1, list2, 1/3)
}
\seealso{
Other IntervalList-method: 
\code{\link{IntervalList-class}},
\code{\link{IntervalList}},
\code{\link{as.IntervalList}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{mean}()},
\code{\link{plot}()},
\code{\link{sum}()},
\code{\link{var}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalList-method}
