% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{evolution}
\alias{evolution}
\title{Th-U evolution diagram}
\usage{
evolution(x, xlim = NA, ylim = NA, alpha = 0.05, transform = FALSE,
  detrital = FALSE, show.numbers = FALSE, ellipse.col = rgb(0, 1, 0, 0.5),
  line.col = "darksalmon", isochron = FALSE, exterr = TRUE, sigdig = 2,
  ...)
}
\arguments{
\item{x}{an object of class \code{ThU}}

\item{xlim}{x-axis limits}

\item{ylim}{y-axis limits}

\item{alpha}{confidence cutoff for the error ellipses}

\item{transform}{if \code{TRUE}, plots \eqn{^{234}}U/\eqn{^{238}}U
vs. Th-U age.}

\item{detrital}{apply a detrital Th correction by projecting the
compositions along an isochron?}

\item{show.numbers}{label the error ellipses with the grain
numbers?}

\item{ellipse.col}{background colour of the error ellipses}

\item{line.col}{colour of the age grid}

\item{isochron}{fit a 3D isochron to the data?}

\item{exterr}{propagate the decay constant uncertainty in the
isochron age?}

\item{sigdig}{number of significant digits for the isochron age}

\item{...}{optional arguments to the generic \code{plot} function}
}
\description{
Plots Th-U data on a
\eqn{^{234}}U/\eqn{^{238}}U-\eqn{^{230}}Th/\eqn{^{238}}U evolution
diagram or a \eqn{^{234}}U/\eqn{^{238}}U-age diagram, calculates
isochron ages.
}
\examples{
data(examples)
evolution(examples$ThU)

}
\references{
Ludwig, K.R. and Titterington, D.M., 1994. Calculation
    of \eqn{^{230}}Th/U isochrons, ages, and errors. Geochimica et
    Cosmochimica Acta, 58(22), pp.5031-5042.

Ludwig, K.R., 2003. Mathematical-statistical treatment of data and
    errors for 230 Th/U geochronology. Reviews in Mineralogy and
    Geochemistry, 52(1), pp.631-656.
}
