% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{age}
\alias{age}
\alias{age.default}
\alias{age.UPb}
\alias{age.PbPb}
\alias{age.ArAr}
\alias{age.UThHe}
\alias{age.fissiontracks}
\alias{age.ThU}
\alias{age.ReOs}
\alias{age.SmNd}
\alias{age.RbSr}
\alias{age.LuHf}
\title{Calculate isotopic ages}
\usage{
age(x, ...)

\method{age}{default}(x, method = "U238-Pb206", exterr = TRUE, J = c(NA,
  NA), zeta = c(NA, NA), rhoD = c(NA, NA), ...)

\method{age}{UPb}(x, type = 1, wetherill = TRUE, exterr = TRUE, i = NA,
  sigdig = NA, common.Pb = 0, ...)

\method{age}{PbPb}(x, isochron = TRUE, i2i = TRUE, exterr = TRUE,
  i = NA, sigdig = NA, ...)

\method{age}{ArAr}(x, isochron = FALSE, i2i = TRUE, exterr = TRUE,
  i = NA, sigdig = NA, ...)

\method{age}{UThHe}(x, central = FALSE, i = NA, sigdig = NA, ...)

\method{age}{fissiontracks}(x, central = FALSE, i = NA, sigdig = NA,
  exterr = TRUE, ...)

\method{age}{ThU}(x, isochron = FALSE, i2i = TRUE, exterr = TRUE,
  i = NA, sigdig = NA, ...)

\method{age}{ReOs}(x, isochron = TRUE, i2i = TRUE, exterr = TRUE,
  i = NA, sigdig = NA, ...)

\method{age}{SmNd}(x, isochron = TRUE, i2i = TRUE, exterr = TRUE,
  i = NA, sigdig = NA, ...)

\method{age}{RbSr}(x, isochron = TRUE, i2i = TRUE, exterr = TRUE,
  i = NA, sigdig = NA, ...)

\method{age}{LuHf}(x, isochron = TRUE, i2i = TRUE, exterr = TRUE,
  i = NA, sigdig = NA, ...)
}
\arguments{
\item{x}{can be:
\itemize{
\item a scalar containing an isotopic ratio,

\item a two element vector containing an isotopic ratio and its standard
error, or the spontaneous and induced track densities \code{Ns} and
\code{Ni} (if \code{method='fissiontracks'}),

\item a four element vector containing \code{Ar40Ar39},
\code{s[Ar40Ar39]}, \code{J}, \code{s[J]},

\item a six element vector containing \code{U}, \code{s[U]}, \code{Th},
\code{s[Th]}, \code{He} and \code{s[He]},

\item an eight element vector containing \code{U}, \code{s[U]},
\code{Th}, \code{s[Th]}, \code{He}, \code{s[He]}, \code{Sm} and
\code{s[Sm]}

\item a six element vector containing \code{Rb}, \code{s[Rb]},
\code{Sr}, \code{s[Sr]}, \code{Sr87Sr86}, and \code{s[Sr87Sr86]}

\item a six element vector containing \code{Re}, \code{s[Re]},
\code{Os}, \code{s[Os]}, \code{Os187Os188}, and \code{s[Os187Os188]}

\item a six element vector containing \code{Sm}, \code{s[Sm]},
\code{Nd}, \code{s[Nd]}, \code{Nd143Nd144}, and \code{s[Nd144Nd143]}

\item a six element vector containing \code{Lu}, \code{s[Lu]},
\code{Hf}, \code{s[Hf]}, \code{Hf176Hf177}, and \code{s[Hf176Hf177]}

\item a five element vector containing \code{4/8}, \code{s[4/8]},
\code{0/8}, \code{s[0/8]}, and \code{cov[4/8,0/8]}
}

OR

\itemize{
\item an object of class \code{UPb}, \code{PbPb}, \code{ArAr}, \code{ThU},
\code{RbSr}, \code{SmNd}, \code{ReOs}, \code{LuHf}, \code{UThHe} or
\code{fissiontracks}.
}}

\item{...}{additional arguments}

\item{method}{one of either \code{'U238-Pb206'}, \code{'U235-Pb207'},
\code{'Pb207-Pb206'}, \code{'Ar-Ar'}, \code{'Th-U'}, \code{'Re-Os'},
\code{'Sm-Nd'}, \code{'Rb-Sr'}, \code{'Lu-Hf'}, \code{'U-Th-He'} or
\code{'fissiontracks'}}

\item{exterr}{propagate the external (decay constant and
calibration factor) uncertainties?}

\item{J}{two-element vector with the J-factor and its standard
error.}

\item{zeta}{two-element vector with the zeta-factor and its standard
error.}

\item{rhoD}{two-element vector with the track density of the
dosimeter glass and its standard error.}

\item{type}{scalar flag indicating whether each U-Pb analysis
should be considered separately (\code{type=1}), a
concordia age should be calculated from all U-Pb analyses
together (\code{type=2}), or a discordia line should be
fit through all the U-Pb analyses (\code{type=3}).}

\item{wetherill}{logical flag to indicate whether the data should
be evaluated in Wetherill (\code{TRUE}) or Tera-Wasserburg
(\code{FALSE}) space.  This option is only used when
\code{type=2}}

\item{i}{(optional) index of a particular aliquot}

\item{sigdig}{number of significant digits for the uncertainty
estimate (only used if \code{type=1}, \code{isochron=FALSE}
or \code{central=FALSE}).}

\item{common.Pb}{apply a common lead correction using one of three
    methods:

\code{1}: use the isochron intercept as the initial Pb-composition

\code{2}: use the Stacey-Kramer two-stage model to infer the initial
Pb-composition

\code{3}: use the Pb-composition stored in
\code{settings('iratio','Pb206Pb204')} and
\code{settings('iratio','Pb207Pb204')}}

\item{isochron}{logical flag indicating whether each Ar-Ar analysis
should be considered separately (\code{isochron=FALSE}) or an
isochron age should be calculated from all Ar-Ar analyses
together (\code{isochron=TRUE}).}

\item{i2i}{`isochron to intercept': calculates the initial (aka `inherited',
`excess', or `common') \eqn{^{40}}Ar/\eqn{^{36}}Ar,
\eqn{^{207}}Pb/\eqn{^{204}}Pb, \eqn{^{87}}Sr/\eqn{^{86}}Sr,
\eqn{^{143}}Nd/\eqn{^{144}}Nd, \eqn{^{187}}Os/\eqn{^{188}}Os or
\eqn{^{176}}Hf/\eqn{^{177}}Hf ratio from an isochron
fit. Setting \code{i2i} to \code{FALSE} uses the default values
stored in \code{settings('iratio',...)}  or zero (for the Pb-Pb
method). When applied to data of class \code{ThU}, setting
\code{i2i} to \code{TRUE} applies a detrital Th-correction.}

\item{central}{logical flag indicating whether each U-Th-He analysis
should be considered separately (\code{central=FALSE}) or a
central age should be calculated from all U-Th-He analyses
together (\code{central=TRUE}).}
}
\value{
\enumerate{

\item if \code{x} is a scalar or a vector, returns the age using
the geochronometer given by \code{method} and its standard error.

\item if \code{x} has class \code{UPb} and \code{type=1},
returns a table with the following columns: \code{t.75},
\code{err[t.75]}, \code{t.68}, \code{err[t.68]}, \code{t.76},
\code{err[t.76]}, \code{t.conc}, \code{err[t.conc]}, containing the
\eqn{^{207}}Pb/\eqn{^{235}}U-age and standard error, the
\eqn{^{206}}Pb/\eqn{^{238}}U-age and standard error, the
\eqn{^{207}}Pb/\eqn{^{206}}Pb-age and standard error, and the
concordia age and standard error, respectively.
 
\item if \code{x} has class \code{UPb} and \code{type=2},
returns a list with the following items:

\describe{
\item{x}{ a named vector with the (weighted mean) U-Pb composition }

\item{cov}{ the covariance matrix of the (mean) U-Pb composition }

\item{age}{ the concordia age (in Ma) }

\item{age.err}{ the standard error of the concordia age }

\item{mswd}{ a list with two items (\code{equivalence} and
\code{concordance}) containing the MSWD (Mean of the Squared
Weighted Deviates, a.k.a the reduced Chi-squared statistic outside
of geochronology) of isotopic equivalence and age concordance,
respectively. }

\item{p.value}{ a list with two items (\code{equivalence} and
\code{concordance}) containing the p-value of the Chi-square test
for isotopic equivalence and age concordance, respectively. }
}

\item if \code{x} has class \code{UPb} and \code{type=3},
returns a list with the following items:

\describe{
\item{x}{ a two element vector with the upper and lower intercept
ages (if \code{wetherill=TRUE}) or the lower intercept age and
\eqn{^{207}}Pb/\eqn{^{206}}Pb intercept (for Tera-Wasserburg) }

\item{cov}{ the covariance matrix of the elements in \code{x} }
}

\item if \code{x} has class \code{PbPb}, \code{ArAr}, \code{RbSr},
\code{SmNd}, \code{ReOs}, \code{LuHf} and \code{isochron=FALSE},
returns a table of Pb-Pb, Ar-Ar, Rb-Sr, Sm-Nd, Re-Os or Lu-Hf and
standard errors.

\item if \code{x} has class \code{PbPb}, \code{ArAr}, \code{RbSr},
\code{SmNd}, \code{ReOs} or \code{LuHf} and \code{isochron=TRUE},
returns a list with the following items:

\describe{

\item{a}{the intercept of the straight line fit and its standard
error.}

\item{b}{the slope of the fit and its standard error.}

\item{cov.ab}{the covariance of the slope and intercept}

\item{mswd}{the mean square of the residuals (a.k.a
    `reduced Chi-square') statistic}

\item{p.value}{the p-value of a Chi-square test for linearity}

\item{y0}{the atmospheric \eqn{^{40}}Ar/\eqn{^{36}}Ar or initial
\eqn{^{207}}Pb/\eqn{^{204}}Pb, \eqn{^{187}}Os/\eqn{^{188}}Os,
\eqn{^{87}}Sr/\eqn{^{86}}Sr, \eqn{^{143}}Nd/\eqn{^{144}}Nd or
\eqn{^{176}}Hf/\eqn{^{177}}Hf ratio and its standard error.}

\item{age}{the \eqn{^{207}}Pb/\eqn{^{206}}Pb,
\eqn{^{40}}Ar/\eqn{^{39}}Ar, \eqn{^{187}}Os/\eqn{^{187}}Re,
\eqn{^{87}}Sr/\eqn{^{86}}Sr, \eqn{^{143}}Nd/\eqn{^{144}}Nd or
\eqn{^{176}}Hf/\eqn{^{177}}Hf age and its standard error.}
    
}

\item if \code{x} has class \code{ThU} and \code{isochron=FALSE},
returns a 5-column table with the Th-U ages, their standard errors,
the initial \eqn{^{234}U/^{238}U}-ratios, their standard errors,
and the correlation coefficient between the ages and the initial
ratios.

\item if \code{x} has class \code{ThU} and \code{isochron=TRUE},
returns the output of an `Osmond Type-II' isochron, i.e.:

\describe{

\item{par}{the best fitting \eqn{^{234}U/^{238}U} intercept,
\eqn{^{234}U/^{232}Th} slope, \eqn{^{230}Th/^{238}U} intercept and
\eqn{^{230}Th/^{232}Th} slope.}

\item{cov}{the covariance matrix of \code{par}.}

\item{a}{the \eqn{^{234}U/^{238}U} intercept (i.e. the detrital
Th-corrected value) and its standard error.}

\item{b}{the \eqn{^{234}U/^{232}Th} slope and its standard error.}

\item{cov.ab}{the covariance of \code{a} and \code{b}.}

\item{mswd}{the mean square of the residuals (a.k.a
    `reduced Chi-square') statistic.}

\item{p.value}{the p-value of a Chi-square test for linearity.}

\item{y0}{the initial \eqn{^{234}U/^{238}U}-ratio and its standard
error.}

\item{age}{the Th-U isochron age and its standard error.}

}

\item if \code{x} has class \code{UThHe} and \code{central=TRUE},
returns a list with the following items:

\describe{

\item{uvw}{ a three-element list with the weighted mean log[U/He],
log[Th/He] and log[Sm/He] compositions. }

\item{covmat}{ a 3x3 covariance matrix for \code{uvw}}

\item{mswd}{ the reduced Chi-square value for the
log[U/He]-log[Th/He] compositions. }

\item{p.value}{ the p-value of concordance between the
log[U/He]-log[Th/He] compositions. }

\item{age}{ two-element vector with the central age and its
standard error. }

}

\item if \code{x} has class \code{fissiontracks} and
\code{central=FALSE}, returns a table of fission track ages and
standard errors.

\item if \code{x} has class \code{fissiontracks} and
\code{central=TRUE}, returns a list with the following items:

\describe{

\item{mswd}{ the reduced Chi-square value for the fission track
ages. }

\item{p.value}{ the p-value of concordance between the fission
track ages. }

\item{age}{ a two-element vector with the central age and its
standard error. }

\item{disp}{ the (over)dispersion of the single grain ages beyond
the formal analytical uncertainties. }
}
}
}
\description{
Calculates  ages and propagates their analytical
uncertainties.
}
\examples{
data(examples)
print(age(examples$UPb))
print(age(examples$UPb,type=1))
print(age(examples$UPb,type=2))
}
