/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import jedit.syntax.DefaultInputHandler;
import jedit.syntax.InputHandler;
import jedit.syntax.JEditTextArea;
import jedit.syntax.TextAreaPainter;
import jedit.syntax.TextUtilities;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.editor.CodeCompletion;

public class RInputHandler
extends DefaultInputHandler {
    public static final ActionListener R_INSERT_TAB = new r_insert_tab();
    public static final ActionListener R_RUN_LINES = new r_run_lines();
    public static final ActionListener R_RUN_ALL = new r_run_all();
    public static final ActionListener R_COMMENT_LINES = new r_comment_lines();
    public static final ActionListener R_PREV_LINE = new r_prev_line(false);
    public static final ActionListener R_NEXT_LINE = new r_next_line(false);
    public static final ActionListener R_CLOSE_POPUPS = new r_close_popups();
    public static final ActionListener R_INSERT_BREAK = new r_insert_break();
    public static Popup codeCompletion;
    private String funHelp = null;
    private JToolTip Tip;
    private Popup funHelpTip = null;

    public void addKeyBindings() {
        this.addDefaultKeyBindings();
        this.addKeyBinding("TAB", R_INSERT_TAB);
        this.addKeyBinding("M+ENTER", R_RUN_LINES);
        this.addKeyBinding("M+7", R_COMMENT_LINES);
        this.addKeyBinding("UP", R_PREV_LINE);
        this.addKeyBinding("DOWN", R_NEXT_LINE);
        this.addKeyBinding("ESCAPE", R_CLOSE_POPUPS);
        this.addKeyBinding("ENTER", R_INSERT_BREAK);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (codeCompletion != null && keyEvent.getKeyCode() != 38 && keyEvent.getKeyCode() != 40) {
            JEditTextArea jEditTextArea = RInputHandler.getTextArea(keyEvent);
            int n = jEditTextArea.getCaretPosition();
            int n2 = jEditTextArea.getCaretLine();
            String string = jEditTextArea.getLineText(n2);
            int n3 = 0;
            int n4 = n;
            try {
                n3 = TextUtilities.findWordStart(string, n - jEditTextArea.getLineStartOffset(n2) - 1, ".");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            try {
                n4 = TextUtilities.findWordEnd(string, n - jEditTextArea.getLineStartOffset(n2) - 1, ".");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            String string2 = null;
            try {
                string2 = string.substring(n3, n4);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            int n5 = -1;
            if (string2 == null || string2.trim().length() == 0 || (n5 = CodeCompletion.getInstance().updateList(string2)) < 1) {
                codeCompletion.hide();
                codeCompletion = null;
            }
        }
        super.keyReleased(keyEvent);
    }

    static {
        actions.put("insert-tab", R_INSERT_TAB);
        actions.put("run-lines", R_RUN_LINES);
        actions.put("run-all", R_RUN_ALL);
        actions.put("comment-lines", R_COMMENT_LINES);
        actions.put("prev-line", R_PREV_LINE);
        actions.put("next-line", R_NEXT_LINE);
        actions.put("close-popups", R_CLOSE_POPUPS);
        actions.put("insert-break", R_INSERT_BREAK);
    }

    public static class r_insert_break
    extends InputHandler.insert_break {
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            if (!jEditTextArea.isEditable()) {
                jEditTextArea.getToolkit().beep();
                return;
            }
            if (codeCompletion != null) {
                String string = CodeCompletion.getInstance().getCompletion();
                jEditTextArea.setSelectedText(string);
                codeCompletion.hide();
                codeCompletion = null;
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    public static class r_prev_line
    extends InputHandler.prev_line {
        public r_prev_line(boolean bl) {
            super(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (codeCompletion != null) {
                CodeCompletion.getInstance().previous();
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    public static class r_next_line
    extends InputHandler.next_line {
        public r_next_line(boolean bl) {
            super(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (codeCompletion != null) {
                CodeCompletion.getInstance().next();
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    public static class r_close_popups
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (codeCompletion != null) {
                codeCompletion.hide();
                codeCompletion = null;
            }
        }
    }

    public static class r_run_all
    extends InputHandler.insert_tab {
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            int n = 0;
            int n2 = jEditTextArea.getLineCount();
            for (int i = n; i < n2; ++i) {
                String string = jEditTextArea.getLineText(i).trim();
                if (string.length() <= 0) continue;
                System.out.println("run cmd: " + string);
            }
        }
    }

    public static class r_comment_lines
    extends InputHandler.insert_tab {
        public static final String COMMENT_CHAR = "#";

        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            int n = jEditTextArea.getSelectionStartLine();
            int n2 = jEditTextArea.getSelectionEndLine();
            if (n < 0) {
                n = n2 = jEditTextArea.getCaretLine();
            }
            for (int i = n; i <= n2; ++i) {
                int n3 = jEditTextArea.getLineStartOffset(i);
                try {
                    if (jEditTextArea.getLineText(i).trim().startsWith(COMMENT_CHAR)) {
                        jEditTextArea.getDocument().remove(n3, jEditTextArea.getLineText(i).indexOf(COMMENT_CHAR) + 1);
                        continue;
                    }
                    jEditTextArea.getDocument().insertString(n3, COMMENT_CHAR, null);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    public static class r_run_lines
    extends InputHandler.insert_tab {
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea = InputHandler.getTextArea(actionEvent);
            int n = jEditTextArea.getSelectionStartLine();
            int n2 = jEditTextArea.getSelectionEndLine();
            if (n >= 0 && n2 < jEditTextArea.getLineCount()) {
                for (int i = n; i <= n2; ++i) {
                    String string = jEditTextArea.getLineText(i).trim();
                    if (string.length() <= 0) continue;
                    JGR.MAINRCONSOLE.execute(string.trim(), true);
                }
            }
        }
    }

    public static class r_insert_tab
    extends InputHandler.insert_tab {
        public void actionPerformed(ActionEvent actionEvent) {
            JEditTextArea jEditTextArea;
            int n;
            if (codeCompletion != null) {
                codeCompletion.hide();
                codeCompletion = null;
            }
            if ((n = (jEditTextArea = InputHandler.getTextArea(actionEvent)).getCaretPosition()) > 0 && jEditTextArea.getText(n - 1, 1).trim().length() != 0) {
                int n2 = jEditTextArea.getCaretLine();
                String string = jEditTextArea.getLineText(n2);
                int n3 = 0;
                int n4 = n;
                try {
                    n3 = TextUtilities.findWordStart(string, n - jEditTextArea.getLineStartOffset(n2) - 1, ".");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    n4 = TextUtilities.findWordEnd(string, n - jEditTextArea.getLineStartOffset(n2) - 1, ".");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                boolean bl = false;
                String string2 = "";
                try {
                    string2 = string.substring(n3, n4).trim();
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (string2.length() <= 0) {
                    super.actionPerformed(actionEvent);
                    return;
                }
                try {
                    bl = string.substring(n3 - 1, n3).equalsIgnoreCase("\"");
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                int n5 = jEditTextArea._offsetToX(n2, n);
                int n6 = jEditTextArea.lineToY(n2);
                Point point = new Point(n5, n6);
                SwingUtilities.convertPointToScreen(point, (Component)actionEvent.getSource());
                int n7 = -1;
                n7 = bl ? CodeCompletion.getInstance().updateFileList(string2) : CodeCompletion.getInstance().updateList(string2);
                if (n7 > 0) {
                    codeCompletion = PopupFactory.getSharedInstance().getPopup((Component)actionEvent.getSource(), CodeCompletion.getInstance(), point.x, point.y + TextAreaPainter.FONTSIZE + 10);
                    codeCompletion.show();
                }
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }
}

