/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.browser.BrowserController;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.REngine.REXP;

public class HeadNode
implements BrowserNode {
    ArrayList children = new ArrayList();
    protected boolean expanded = true;
    TreeCellRenderer renderer = new BlankCellRenderer();

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        return (TreeNode)this.children.get(n);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (treeNode != this.children.get(i)) continue;
            return i;
        }
        return -1;
    }

    public TreeNode getParent() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }

    public String getExecuteableRObjectName() {
        return "globalenv()";
    }

    public String getChildExecuteableRObjectName(BrowserNode browserNode) {
        return browserNode.getRName();
    }

    public TreeCellRenderer getRenderer() {
        return this.renderer;
    }

    public String getRName() {
        return null;
    }

    public void addChild(BrowserNode browserNode) {
        this.children.add(browserNode);
    }

    public void insert(MutableTreeNode mutableTreeNode, int n) {
        this.children.add(n, mutableTreeNode);
    }

    public void remove(int n) {
        this.children.remove(n);
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        this.children.remove(this.getIndex(mutableTreeNode));
    }

    public void removeFromParent() {
    }

    public void setParent(MutableTreeNode mutableTreeNode) {
    }

    public void setUserObject(Object object) {
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public void update(DefaultTreeModel defaultTreeModel) {
        final DefaultTreeModel defaultTreeModel2 = defaultTreeModel;
        if (!this.expanded) {
            return;
        }
        try {
            REXP rEXP = JGR.idleEval("ls()");
            if (rEXP == null) {
                return;
            }
            String[] stringArray = rEXP.asStrings();
            String[] stringArray2 = new String[]{};
            if (stringArray.length > 0) {
                rEXP = JGR.idleEval("sapply(ls(),function(a)class(get(a,envir=globalenv()))[1])");
                if (rEXP == null) {
                    return;
                }
                stringArray2 = rEXP.asStrings();
            }
            if (stringArray.length < this.children.size()) {
                final String[] stringArray3 = stringArray;
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        for (int i = HeadNode.this.children.size() - 1; i >= stringArray3.length; --i) {
                            defaultTreeModel2.removeNodeFromParent((MutableTreeNode)HeadNode.this.children.get(i));
                        }
                    }
                });
            }
            int n = Math.min(stringArray.length, BrowserController.MAX_CHILDREN);
            for (int i = 0; i < n; ++i) {
                if (i >= stringArray2.length) continue;
                final BrowserNode browserNode = BrowserController.createNode(this, stringArray[i], stringArray2[i]);
                if (this.children.size() > i && this.children.get(i).equals(browserNode)) {
                    ((BrowserNode)this.children.get(i)).update(defaultTreeModel);
                    continue;
                }
                final Object[] objectArray = this.children.toArray();
                final int n2 = i;
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        if (objectArray.length > n2) {
                            for (int i = n2; i < objectArray.length; ++i) {
                                defaultTreeModel2.removeNodeFromParent((MutableTreeNode)objectArray[i]);
                            }
                        }
                        defaultTreeModel2.insertNodeInto(browserNode, HeadNode.this, HeadNode.this.children.size());
                    }
                });
                browserNode.update(defaultTreeModel2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public JPopupMenu getPopupMenu() {
        return null;
    }

    public void editObject() {
    }

    public void removeChildObjectFromR(BrowserNode browserNode) {
        JGR.MAINRCONSOLE.execute("rm(\"" + browserNode.getRName() + "\",envir=" + this.getExecuteableRObjectName() + ")");
    }

    class BlankCellRenderer
    implements TreeCellRenderer {
        JLabel lab = new JLabel();

        BlankCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            return this.lab;
        }
    }
}

