% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sim_vcpsr.R
\name{plot.simvcpsr}
\alias{plot.simvcpsr}
\title{Plotting function for \code{sim_vcpsr}}
\usage{
\method{plot}{simvcpsr}(x, ..., xlab = " ", ylab = " ", Resol = 100)
}
\arguments{
\item{x}{the P-spline object, usually from \code{sim_vcpsr}.}

\item{...}{other parameters.}

\item{xlab}{label for the x-axis, e.g. "my x" (quotes required).}

\item{ylab}{label for the y-axis, e.g. "my y" (quotes required).}

\item{Resol}{resolution for plotting, default \code{Resol = 100}.}
}
\value{
\item{Plot}{a plot of the estimated 2D P-spline signal coefficent surface along with the companion plot of the estimated
2D P-spline varying link function surface. Slices of these plots, at fixed levels of the indexing covariate, are also provided.}
}
\description{
Plotting function for varying-coefficent single-index signal
regression using tensor P-splines (using \code{sim_vcpsr} with \code{class simvcpsr}).
}
\references{
Marx, B. D. (2015). Varying-coefficient single-index signal
regression. \emph{Chemometrics and Intellegent Laboratory Systems}, 143, 111–121.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.

#' @examples
# Load libraries
library(fields) # Needed for plotting

# Get the data
Dat <- Mixture

# Dimensions: observations, temperature index, signal
m <- 34
p1 <- 401
p2 <- 12

# Stacking mixture data, each mixture has 12 signals stacked
# The first differenced spectra are also computed.
mixture_data <- matrix(0, nrow = p2 * m, ncol = p1)
for (ii in 1:m)
{
  mixture_data[((ii - 1) * p2 + 1):(ii * p2), 1:p1] <-
    t(as.matrix(Dat$xspectra[ii, , ]))
  d_mixture_data <- t(diff(t(mixture_data)))
}

# Response (typo fixed) and index for signal
y_mixture <- Dat$fractions
y_mixture[17, 3] <- 0.1501
index_mixture <- Dat$wl

# Select response and replicated for the 12 temps
# Column 1: water; 2: ethanediol; 3: amino-1-propanol
y <- as.vector(y_mixture[, 2])
y <- rep(y, each = p2)

bdegs = c(3, 3, 3, 3)
pords <- c(2, 2, 2, 2)
nsegs <- c(12, 5, 5, 5) # Set to c(27, 7, 7 ,7) for given lambdas
mins <- c(700, 30)
maxs <- c(1100, 70)
lambdas <- c(1e-11, 100, 0.5, 1) # based on svcm search
x_index <- seq(from = 701, to = 1100, by = 1) # for dX
t_var_sub <- c(30, 35, 37.5, 40, 45, 47.5, 50, 55, 60, 62.5, 65, 70)
t_var <- rep(t_var_sub, m)
max_iter <- 2 # Set higher in practice, e.g. 100
int <- TRUE

# Defining x as first differenced spectra, number of channels.
x <- d_mixture_data


# Single-index VC model using optimal tuning
fit <- sim_vcpsr(y, x, t_var, x_index, nsegs, bdegs, lambdas, pords,
             max_iter = max_iter, mins = mins, maxs = maxs)

plot(fit, xlab = "Wavelength (nm)", ylab = "Temp C")
}
\author{
Paul Eilers and Brian Marx
}
