% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLM_Signal_2D_support.R
\name{pspline2d_checker}
\alias{pspline2d_checker}
\title{P-spline 2D tensor product checking algorithm for the GLM.}
\usage{
pspline2d_checker(
  family,
  link,
  bdeg1,
  bdeg2,
  pord1,
  pord2,
  nseg1,
  nseg2,
  lambda1,
  lambda2,
  ridge_adj,
  wts
)
}
\arguments{
\item{family}{the response distribution, e.g. \code{"gaussian", "binomial", "poisson", "Gamma"} distribution. Quotes are needed.}

\item{link}{the link function, one of \code{"identity"}, \code{"log"}, \code{"sqrt"},
\code{"logit"}, \code{"probit"}, \code{"cloglog"}, \code{"loglog"}, \code{"reciprocal"};
quotes are needed.}

\item{bdeg1}{the degree of B-splines.}

\item{bdeg2}{the degree of B-splines.}

\item{pord1}{the order of the penalty.}

\item{pord2}{the order of the penalty.}

\item{nseg1}{the number of evenly spaced B-spline segmements.}

\item{nseg2}{the number of evenly spaced B-spline segmements.}

\item{lambda1}{the positive tuning parameter for the difference penalty.}

\item{lambda2}{the positive tuning parameter for the difference penalty.}

\item{ridge_adj}{the positive tuning parameter for the ridge penalty.}

\item{wts}{the weight vector, separate from GLM weights.}
}
\value{
\item{list}{same as inputs, with warnings if required.}
}
\description{
\code{pspline_2dchecker} checks to see if all the 2D tensor inputs associated
for P-spines are properly defined.
}
