% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaboost.R
\name{adaboost}
\alias{adaboost}
\title{AdaBoost Classifier}
\usage{
adaboost(X, y, tree_depth = 3, n_rounds = 100, verbose = FALSE)
}
\arguments{
\item{X}{A matrix of continuous predictors.}

\item{y}{A vector of responses with entries in \code{c(-1, 1)}.}

\item{tree_depth}{The depth of the base tree classifier to use.}

\item{n_rounds}{The number of rounds of boosting to use.}

\item{verbose}{Whether to print the number of iterations.}
}
\value{
Returns an object of class AdaBoost containing the following values:
\item{alphas}{Weights computed in the adaboost fit.}
\item{trees}{The trees constructed in each round of boosting.  Storing trees
             allows one to make predictions on new data.}
\item{confusion_matrix}{A confusion matrix for the in-sample fits.}
}
\description{
An implementation of the AdaBoost algorithm from Freund and Shapire (1997)
applied to decision tree classifiers.
}
\note{
Trees are grown using the CART algorithm implemented in the \code{rpart}
      package.  In order to conserve memory, the only parts of the fitted
      tree objects that are retained are those essential to making predictions.
      In practice, the number of rounds of boosting to use is chosen by
      cross-validation.
}
\examples{
\dontrun{
# Generate data from the circle model
set.seed(111)
dat = circle_data(n = 500)
train_index = sample(1:500, 400)

ada = adaboost(dat$X[train_index,], dat$y[train_index], tree_depth = 2,
               n_rounds = 200, verbose = TRUE)
print(ada)
yhat_ada = predict(ada, dat$X[-train_index,])

# calculate misclassification rate
mean(dat$y[-train_index] != yhat_ada)
}
}
\references{
Freund, Y. and Schapire, R. (1997). A decision-theoretic
generalization of online learning and an application to boosting, Journal of
 Computer and System Sciences 55: 119-139.
}
