% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{mvqq}
\alias{mvqq}
\title{This is a simple plotting function designed to help examine
multivariate normality using the (squared) Mahalanobis distance.}
\usage{
mvqq(dat, use = c("fiml", "pairwise.complete.obs", "complete.obs"),
  plot = TRUE)
}
\arguments{
\item{dat}{A data frame or matrix of multivariate data to be plotted}

\item{use}{A character vector indicating how the moments
(means and covariance matrix) should be estimated in the presence of
missing data.  The default is to use full information maximum likelihood
based on functions in \pkg{lavaan}.}

\item{plot}{A logical argument whether to plot the results. Defaults to \code{TRUE}.}
}
\value{
An invisible list of the density plot, QQ plot, and the data containing
  quantiles from the chi-squared distribution. Can be useful to find and remove
  multivariate outliers.
}
\description{
This is a simple plotting function designed to help examine
multivariate normality using the (squared) Mahalanobis distance.
}
\examples{
mvqq(mtcars)

}
\seealso{
\code{\link{SEMSummary}}
}
\keyword{multivariate}

