% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styler.R
\name{formatLMER}
\alias{formatLMER}
\title{Format results from a linear mixed model}
\usage{
formatLMER(list, modelnames, format = list(FixedEffects =
  c("\%s\%s [\%s, \%s]"), RandomEffects = c("\%s", "\%s [\%s, \%s]"),
  EffectSizes = c("\%s/\%s, \%s")), digits = 2, pcontrol = list(digits
  = 3, stars = TRUE, includeP = FALSE, includeSign = FALSE, dropLeadingZero
  = TRUE), ...)
}
\arguments{
\item{list}{A list of one (or more) models estimated from lmer}

\item{modelnames}{An (optional) vector of names to use in
the column headings for each model.}

\item{format}{A list giving the formatting style to be used for
the fixed effecvts, random effects, and effect sizes.
For the random effects, must be two options, one for when the
random effects do not have confidence intervals and one when the
random effects do have confidence intervals.}

\item{digits}{A numeric value indicating the number of digits to print.
This is still in early implementation stages and currently does not
change all parts of the output (which default to 2 decimals per
APA style).}

\item{pcontrol}{A list controlling how p values are formatted.}

\item{\ldots}{Additional arguments passed to \code{confint}. Notably
\code{nsim} and \code{boot.type} if the bootstrap method is used.}
}
\value{
a data table of character data
}
\description{
Format results from a linear mixed model
}
\examples{

\dontrun{
data(sleepstudy)
m1 <- lme4::lmer(Reaction ~ Days + (1 + Days | Subject),
  data = sleepstudy)
m2 <- lme4::lmer(Reaction ~ Days + I(Days^2) + (1 + Days | Subject),
  data = sleepstudy)

testm1 <- detailedTests(m1, method = "profile")
testm2 <- detailedTests(m2, method = "profile")
formatLMER(list(testm1, testm2))
formatLMER(list(testm1, testm2),
  format = list(
    FixedEffects = "\%s, \%s (\%s, \%s)",
    RandomEffects = c("\%s", "\%s (\%s, \%s)"),
    EffectSizes = "\%s, \%s; \%s"),
  pcontrol = list(digits = 3, stars = FALSE,
                  includeP = TRUE, includeSign = TRUE,
                  dropLeadingZero = TRUE))
}
}
\keyword{misc}
