% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual_acuity.R
\docType{class}
\name{VASummaryObject-class}
\alias{VASummaryObject-class}
\alias{show,VASummaryObject-method}
\alias{plot,VASummaryObject,missing-method}
\title{An S4 class to hold visual acuity summary data}
\usage{
\S4method{show}{VASummaryObject}(object)

\S4method{plot}{VASummaryObject,missing}(x, y, ...)
}
\arguments{
\item{object}{The object to be shown}

\item{x}{A VASummaryObject}

\item{y}{Should be missing}

\item{...}{Additional, unused arguments}
}
\description{
A class designed to hold visual acuity summary data
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: show method

\item \code{plot}: plot method
}}

\section{Slots}{

\describe{
\item{\code{logMAR.combined}}{Numeric values of the combined logarithm of
the minimum angle of resolution data for both eyes}

\item{\code{snellen.combined}}{the snellen values back transformed from the
combined logMAR values}

\item{\code{mean.logMAR}}{average of the logarithm of the minimum angle of resolution data}

\item{\code{mean.snellen}}{average of the combined Snellen data}
}}

