/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Tools.ClassHierarchy;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import org.omegahat.Environment.Tools.ClassHierarchy.ClassNodeAgent;

public class ClassNode {
    protected Class objectClass = ClassNode.classInit();
    protected Class thisClass = null;
    protected Vector parents = new Vector(1);
    protected Vector interfaces = new Vector(1);
    protected Vector children = new Vector(1);
    protected ClassNodeAgent nodeAgent = null;

    public ClassNode() {
    }

    public ClassNode(Class clazz, ClassNodeAgent classNodeAgent) {
        this.thisClass(clazz);
        this.agent(classNodeAgent);
    }

    public synchronized boolean addChild(ClassNode classNode) {
        if (this.children.contains(classNode)) {
            return false;
        }
        this.children.addElement(classNode);
        return true;
    }

    public ClassNodeAgent agent() {
        return this.nodeAgent;
    }

    public ClassNodeAgent agent(ClassNodeAgent classNodeAgent) {
        this.nodeAgent = classNodeAgent;
        return this.agent();
    }

    public Vector children() {
        return this.children;
    }

    public static Class classInit() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Can't load java.lang.Object class!");
        }
        return clazz;
    }

    public boolean compute() {
        this.findParents();
        this.findInterfaces();
        return true;
    }

    public int findInterfaces() {
        Class<?>[] classArray = this.thisClass().getInterfaces();
        ClassNode classNode = null;
        if (classArray == null) {
            return 0;
        }
        int n = 0;
        while (n < classArray.length) {
            classNode = this.agent().addClass(classArray[n], this);
            ++n;
        }
        return classArray.length;
    }

    public int findParents() {
        boolean bl = true;
        Class clazz = this.thisClass();
        int n = 0;
        while (bl) {
            if ((clazz = clazz.getSuperclass()) != null) {
                ClassNode classNode = this.agent().addClass(clazz, this);
                this.parents().addElement(classNode);
                ++n;
                continue;
            }
            bl = false;
        }
        return n;
    }

    public int listChildren(PrintStream printStream) {
        return this.listElements(printStream, this.children);
    }

    public int listElements(PrintStream printStream, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            ClassNode classNode = (ClassNode)enumeration.nextElement();
            printStream.print(String.valueOf(classNode.thisClass().getName()) + (enumeration.hasMoreElements() ? " " : ""));
        }
        return vector2.size();
    }

    public int listParents(PrintStream printStream) {
        return this.listElements(printStream, this.parents);
    }

    public Vector parents() {
        return this.parents;
    }

    public Class thisClass() {
        return this.thisClass;
    }

    public Class thisClass(Class clazz) {
        this.thisClass = clazz;
        return this.thisClass();
    }
}

