/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ANTLRHashString;
import antlr.ANTLRStringBuffer;
import antlr.InputBuffer;
import antlr.ScannerException;
import antlr.Token;
import antlr.Tokenizer;
import antlr.collections.impl.BitSet;
import java.io.IOException;
import java.util.Hashtable;

public abstract class CharScanner
implements Tokenizer {
    static final char NO_CHAR = '\u0000';
    public static final char EOF_CHAR = '\uffff';
    protected int line = 1;
    protected ANTLRStringBuffer text = new ANTLRStringBuffer();
    protected boolean saveConsumedInput = true;
    protected Class tokenObjectClass;
    protected int guessing;
    protected boolean caseSensitive = true;
    protected boolean caseSensitiveLiterals = true;
    protected Hashtable literals;
    protected Token _returnToken;
    protected ANTLRHashString hashString = new ANTLRHashString(this);
    InputBuffer input;

    public CharScanner(InputBuffer inputBuffer) {
        this.setTokenObjectClass("antlr.CommonToken");
        this.input = inputBuffer;
    }

    public void append(char c) {
        if (this.saveConsumedInput) {
            this.text.append(c);
        }
    }

    public void append(String string) {
        if (this.saveConsumedInput) {
            this.text.append(string);
        }
    }

    public void consume() throws IOException {
        if (this.guessing == 0) {
            if (this.caseSensitive) {
                this.append(this.LA(1));
            } else {
                this.append(this.input.LA(1));
            }
        }
        this.input.consume();
    }

    public void consumeUntil(int n) throws IOException {
        while (this.LA(1) != '\uffff' && this.LA(1) != n) {
            this.consume();
        }
    }

    public void consumeUntil(BitSet bitSet) throws IOException {
        while (this.LA(1) != '\uffff' && !bitSet.member(this.LA(1))) {
            this.consume();
        }
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public final boolean getCaseSensitiveLiterals() {
        return this.caseSensitiveLiterals;
    }

    public InputBuffer getInputBuffer() {
        return this.input;
    }

    public int getLine() {
        return this.line;
    }

    public String getText() {
        return this.text.toString();
    }

    public Token getTokenObject() {
        return this._returnToken;
    }

    public char LA(int n) throws IOException {
        if (this.caseSensitive) {
            return this.input.LA(n);
        }
        return this.toLower(this.input.LA(n));
    }

    protected Token makeToken(int n) {
        try {
            Token token = (Token)this.tokenObjectClass.newInstance();
            token.setType(n);
            token.setLine(this.line);
            return token;
        }
        catch (InstantiationException instantiationException) {
            this.panic("can't instantiate a Token");
        }
        catch (IllegalAccessException illegalAccessException) {
            this.panic("Token class is not accessible");
        }
        return Token.badToken;
    }

    public int mark() {
        return this.input.mark();
    }

    public void match(char c) throws ScannerException, IOException {
        if (this.LA(1) != c) {
            throw new ScannerException("mismatched char: '" + this.LA(1) + "' expected '" + c + "'", this.line);
        }
        this.consume();
    }

    public void match(BitSet bitSet) throws ScannerException, IOException {
        if (!bitSet.member(this.LA(1))) {
            throw new ScannerException("mismatched char: '" + this.LA(1) + "'", this.line);
        }
        this.consume();
    }

    public void match(String string) throws ScannerException, IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (this.LA(1) != string.charAt(n2)) {
                throw new ScannerException("mismatched char: '" + this.LA(1) + "'", this.line);
            }
            this.consume();
            ++n2;
        }
    }

    public void matchNot(char c) throws ScannerException, IOException {
        if (this.LA(1) == c) {
            throw new ScannerException("mismatched char: '" + this.LA(1) + "'", this.line);
        }
        this.consume();
    }

    public void matchRange(char c, char c2) throws ScannerException, IOException {
        if (this.LA(1) < c || this.LA(1) > c2) {
            throw new ScannerException("char out of range: '" + this.LA(1) + "'", this.line);
        }
        this.consume();
    }

    public void newline() {
        ++this.line;
    }

    public void panic() {
        System.err.println("CharScanner: panic");
        System.exit(1);
    }

    public void panic(String string) {
        System.err.println("CharScanner; panic: " + string);
        System.exit(1);
    }

    public void reportError(ScannerException scannerException) {
        System.err.println("Scanner exception: " + scannerException);
    }

    public void reportError(String string) {
        System.err.println("Error: " + string);
    }

    public void reportWarning(String string) {
        System.out.println("Warning: " + string);
    }

    public void resetText() {
        this.text.setLength(0);
    }

    public void rewind(int n) {
        this.input.rewind(n);
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public void setText(String string) {
        this.resetText();
        this.text.append(string);
    }

    public void setTokenObjectClass(String string) {
        try {
            this.tokenObjectClass = Class.forName(string);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.panic("ClassNotFoundException: " + string);
            return;
        }
    }

    public int testLiteralsTable(int n) {
        this.hashString.setBuffer(this.text.getBuffer(), this.text.length());
        Integer n2 = (Integer)this.literals.get(this.hashString);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public char toLower(char c) {
        return Character.toLowerCase(c);
    }

    public void traceIn(String string) throws IOException {
        System.out.println("enter lexer " + string + "; c==" + this.LA(1));
    }

    public void traceOut(String string) throws IOException {
        System.out.println("exit lexer " + string + "; c=='" + this.LA(1));
    }

    public abstract Token nextToken() throws IOException;
}

