/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ParserException;
import antlr.Token;
import antlr.collections.AST;
import antlr.collections.impl.BitSet;

public class MismatchedTokenException
extends ParserException {
    String[] tokenNames;
    public Token token;
    public AST node;
    String tokenText;
    public static final int TOKEN = 1;
    public static final int NOT_TOKEN = 2;
    public static final int RANGE = 3;
    public static final int NOT_RANGE = 4;
    public static final int SET = 5;
    public static final int NOT_SET = 6;
    protected int mismatchType;
    protected int expecting;
    protected int upper;
    protected BitSet set;

    public MismatchedTokenException() {
        super("Mismatched Token: expecting any AST node");
    }

    public MismatchedTokenException(String[] stringArray, AST aST, int n, int n2, boolean bl) {
        super("Mismatched Token");
        this.tokenNames = stringArray;
        this.node = aST;
        this.tokenText = aST == null ? "<empty tree>" : aST.toString();
        this.expecting = n;
        this.upper = n2;
        this.mismatchType = bl ? 4 : 3;
    }

    public MismatchedTokenException(String[] stringArray, AST aST, int n, boolean bl) {
        super("Mismatched Token");
        this.tokenNames = stringArray;
        this.node = aST;
        this.tokenText = aST == null ? "<empty tree>" : aST.toString();
        this.expecting = n;
        this.mismatchType = bl ? 2 : 1;
    }

    public MismatchedTokenException(String[] stringArray, AST aST, BitSet bitSet, boolean bl) {
        super("Mismatched Token");
        this.tokenNames = stringArray;
        this.node = aST;
        this.tokenText = aST == null ? "<empty tree>" : aST.toString();
        this.set = bitSet;
        this.mismatchType = bl ? 6 : 5;
    }

    public MismatchedTokenException(String[] stringArray, Token token, int n, int n2, boolean bl) {
        super("Mismatched Token");
        this.tokenNames = stringArray;
        this.token = token;
        this.tokenText = this.token.getText();
        this.expecting = n;
        this.upper = n2;
        this.mismatchType = bl ? 4 : 3;
    }

    public MismatchedTokenException(String[] stringArray, Token token, int n, boolean bl) {
        super("Mismatched Token");
        this.tokenNames = stringArray;
        this.token = token;
        this.tokenText = this.token.getText();
        this.expecting = n;
        this.mismatchType = bl ? 2 : 1;
    }

    public MismatchedTokenException(String[] stringArray, Token token, BitSet bitSet, boolean bl) {
        super("Mismatched Token");
        this.tokenNames = stringArray;
        this.token = token;
        this.tokenText = this.token.getText();
        this.set = bitSet;
        this.mismatchType = bl ? 6 : 5;
    }

    private String tokenName(int n) {
        if (n == 0) {
            return "<Set of tokens>";
        }
        if (n < 0 || n >= this.tokenNames.length) {
            return "<" + String.valueOf(n) + ">";
        }
        return this.tokenNames[n];
    }

    public String toString() {
        String string = this.token == null ? "" : "line(" + this.token.getLine() + "), ";
        switch (this.mismatchType) {
            case 1: {
                string = String.valueOf(string) + "expecting " + this.tokenName(this.expecting) + ", found '" + this.tokenText + "'";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "expecting anything but " + this.tokenName(this.expecting) + "; got it anyway";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "expecting token in range: " + this.tokenName(this.expecting) + ".." + this.tokenName(this.upper) + ", found '" + this.tokenText + "'";
                break;
            }
            case 4: {
                string = String.valueOf(string) + "expecting token NOT in range: " + this.tokenName(this.expecting) + ".." + this.tokenName(this.upper) + ", found '" + this.tokenText + "'";
                break;
            }
            case 5: 
            case 6: {
                string = String.valueOf(string) + "expecting " + (this.mismatchType == 6 ? "NOT " : "") + "one of (";
                int[] nArray = this.set.toArray();
                int n = 0;
                while (n < nArray.length) {
                    string = String.valueOf(string) + " ";
                    string = String.valueOf(string) + this.tokenName(nArray[n]);
                    ++n;
                }
                string = String.valueOf(string) + "), found '" + this.tokenText + "'";
                break;
            }
            default: {
                string = super.toString();
            }
        }
        return string;
    }
}

