/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Parser.Parse;

import org.omegahat.Environment.Interpreter.BasicEvaluator;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.Parser.Parse.Name;
import org.omegahat.Environment.Parser.Parse.Type;

public class CastExpression
extends Type
implements ExpressionInt {
    protected Object array = null;
    protected Object expression = null;
    protected Object evalued = null;
    protected boolean isSuper;
    protected Class castClass;

    public CastExpression(Name name, Object object) {
        super(name);
        this.expression(object);
    }

    public CastExpression(boolean bl, Object object) {
        this.isSuper(bl);
        this.expression(object);
    }

    public Class castClass() {
        return this.castClass;
    }

    public Class castClass(Class clazz) {
        this.castClass = clazz;
        return this.castClass();
    }

    public Class castClass(Evaluator evaluator) throws Exception {
        Class clazz = evaluator.findClass(super.toString());
        return clazz;
    }

    public Object convertToClass(Class clazz, Object object, Evaluator evaluator) throws Exception {
        if (object == null) {
            return object;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        boolean bl = true;
        Object object2 = null;
        if (clazz.isPrimitive()) {
            if (BasicEvaluator.reversePrimitiveTypes.containsKey(clazz.getName()) && BasicEvaluator.reversePrimitiveTypes.get(clazz.getName()).equals(object.getClass())) {
                return object;
            }
            if (clazz == Integer.TYPE) {
                object2 = this.toInt(object);
            } else if (clazz == Double.TYPE) {
                object2 = this.toDouble(object);
            } else if (clazz == Long.TYPE) {
                object2 = this.toLong(object);
            } else if (clazz == Short.TYPE) {
                object2 = this.toShort(object);
            } else if (clazz == Float.TYPE) {
                object2 = this.toFloat(object);
            } else if (clazz == Boolean.TYPE) {
                object2 = this.toBoolean(object);
            } else {
                bl = false;
            }
        }
        if (!bl) {
            throw new Exception("Incompatible cast from " + object.getClass() + " to " + clazz);
        }
        return object2;
    }

    public void error(Class clazz, Object object) throws Exception {
        throw new Exception("Incompatible cast from " + object.getClass() + " to " + clazz);
    }

    public Object eval(Evaluator evaluator) throws Throwable {
        this.evalInit(evaluator);
        this.evalued = this.expression instanceof ExpressionInt ? ((ExpressionInt)this.expression).eval(evaluator) : this.expression;
        Class clazz = null;
        if (this.isSuper()) {
            if (this.evalued != null) {
                clazz = this.castClass(this.evalued.getClass().getSuperclass());
            }
        } else {
            clazz = this.castClass(this.castClass(evaluator));
        }
        if (clazz == null) {
            throw new Exception("Cast to null not allowed");
        }
        return this.convertToClass(clazz, this.evalued, evaluator);
    }

    public Object expression() {
        return this.expression;
    }

    public Object expression(Object object) {
        this.expression = object;
        return this.expression();
    }

    public boolean isSuper() {
        return this.isSuper;
    }

    public boolean isSuper(boolean bl) {
        this.isSuper = bl;
        return this.isSuper();
    }

    public Object toBoolean(Object object) throws Exception {
        Boolean bl = null;
        if (object instanceof Number) {
            bl = new Boolean(((Number)object).intValue() != 0);
        } else {
            this.error(Boolean.TYPE, object);
        }
        return bl;
    }

    public Object toDouble(Object object) throws Exception {
        Double d = null;
        if (object instanceof Number) {
            d = new Double(((Number)object).doubleValue());
        } else {
            this.error(Double.TYPE, object);
        }
        return d;
    }

    public Object toFloat(Object object) throws Exception {
        Float f = null;
        if (object instanceof Number) {
            f = new Float(((Number)object).floatValue());
        } else {
            this.error(Float.TYPE, object);
        }
        return f;
    }

    public Object toInt(Object object) throws Exception {
        Integer n = null;
        if (object instanceof Number) {
            n = new Integer(((Number)object).intValue());
        } else {
            this.error(Integer.TYPE, object);
        }
        return n;
    }

    public Object toLong(Object object) throws Exception {
        Long l = null;
        if (object instanceof Number) {
            l = new Long(((Number)object).longValue());
        } else {
            this.error(Long.TYPE, object);
        }
        return l;
    }

    public Object toShort(Object object) throws Exception {
        Short s = null;
        if (object instanceof Number) {
            s = new Short(((Number)object).shortValue());
        } else {
            this.error(Short.TYPE, object);
        }
        return s;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(" + super.toString() + ")");
        stringBuffer.append(" " + this.expression.toString());
        return stringBuffer.toString();
    }

    public Object value() {
        return this.evalued;
    }
}

