/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Parser.Parse;

import org.omegahat.Environment.DataStructures.EqualityOperator;
import org.omegahat.Environment.DataStructures.RelationalOperator;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.Parser.Parse.NumberExpression;
import org.omegahat.Environment.Parser.Parse.OperatorExpression;

public class LogicalExpression
extends OperatorExpression {
    public LogicalExpression(Object object, Object object2, int n) {
        super(object, object2, n);
    }

    public boolean asLogical(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return object != null;
    }

    public boolean dontDoBoth() {
        int n = this.operator();
        return n == 123;
    }

    public Object eval(Evaluator evaluator) throws Throwable {
        this.evalInit(evaluator);
        boolean[] blArray = new boolean[2];
        Object object = null;
        Object[] objectArray = new Object[2];
        int n = 0;
        while (n < this.els.length) {
            if (this.element(n) != null) {
                objectArray[n] = this.element(n) instanceof ExpressionInt ? ((ExpressionInt)this.element(n)).eval(evaluator) : this.element(n);
                if (n == 0 && this.dontDoBoth() && !this.asLogical(objectArray[n])) {
                    return new Boolean(false);
                }
            }
            ++n;
        }
        object = this.operate(objectArray, evaluator);
        return object;
    }

    public Object operate(Object[] objectArray, Evaluator evaluator) throws Exception {
        boolean bl = false;
        Object object = null;
        if (evaluator.Debug()) {
            System.out.println("operate: " + this.separator() + " " + objectArray[0] + " " + objectArray[1]);
        }
        if (objectArray[0] == null && objectArray[1] == null) {
            if (this.operator() == 128 || this.operator() == 123 || this.operator() == 122) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        if (objectArray[0] == null || objectArray[1] == null) {
            if (this.operator() == 128) {
                return new Boolean(false);
            }
            if (this.operator() == 127) {
                return new Boolean(true);
            }
        }
        if ((objectArray[0] instanceof String || objectArray[1] instanceof String) && (this.operator() == 128 || this.operator() == 127)) {
            String[] stringArray = new String[2];
            int n = 0;
            while (n < 2) {
                stringArray[n] = objectArray[n] != null ? objectArray[n].toString() : null;
                ++n;
            }
            return this.operate(stringArray, evaluator);
        }
        switch (this.operator()) {
            case 128: {
                if (objectArray[0] == null) {
                    bl = objectArray[1] == null;
                    break;
                }
                if (objectArray[0] instanceof Number && objectArray[1] instanceof Number) {
                    bl = NumberExpression.asNumber(objectArray[0]) == NumberExpression.asNumber(objectArray[1]);
                    break;
                }
                if (objectArray[0] instanceof EqualityOperator) {
                    object = ((EqualityOperator)objectArray[0]).Equals(objectArray[1]);
                    break;
                }
                bl = objectArray[0].equals(objectArray[1]);
                break;
            }
            case 127: {
                if (objectArray[0] == null) {
                    bl = objectArray[1] != null;
                    break;
                }
                if (objectArray[0] instanceof EqualityOperator) {
                    object = ((EqualityOperator)objectArray[0]).NotEquals(objectArray[1]);
                    break;
                }
                bl = objectArray[0].equals(objectArray[1]) ^ true;
                break;
            }
            case 130: {
                if (objectArray[0] instanceof RelationalOperator) {
                    object = ((RelationalOperator)objectArray[0]).compare(objectArray[1], this.operator());
                    break;
                }
                bl = NumberExpression.asNumber(objectArray[0]) > NumberExpression.asNumber(objectArray[1]);
                break;
            }
            case 129: {
                if (objectArray[0] instanceof RelationalOperator) {
                    object = ((RelationalOperator)objectArray[0]).compare(objectArray[1], this.operator());
                    break;
                }
                bl = NumberExpression.asNumber(objectArray[0]) < NumberExpression.asNumber(objectArray[1]);
                break;
            }
            case 132: {
                if (objectArray[0] instanceof RelationalOperator) {
                    object = ((RelationalOperator)objectArray[0]).compare(objectArray[1], this.operator());
                    break;
                }
                bl = NumberExpression.asNumber(objectArray[0]) >= NumberExpression.asNumber(objectArray[1]);
                break;
            }
            case 131: {
                if (objectArray[0] instanceof RelationalOperator) {
                    object = ((RelationalOperator)objectArray[0]).compare(objectArray[1], this.operator());
                    break;
                }
                bl = NumberExpression.asNumber(objectArray[0]) <= NumberExpression.asNumber(objectArray[1]);
                break;
            }
            case 123: {
                if (objectArray[0] instanceof RelationalOperator) {
                    object = ((RelationalOperator)objectArray[0]).compare(objectArray[1], this.operator());
                    break;
                }
                bl = this.asBoolean(objectArray[0]) && this.asBoolean(objectArray[1]);
                break;
            }
            case 122: {
                if (objectArray[0] instanceof RelationalOperator) {
                    object = ((RelationalOperator)objectArray[0]).compare(objectArray[1], this.operator());
                    break;
                }
                bl = this.asBoolean(objectArray[0]) || this.asBoolean(objectArray[1]);
                break;
            }
            case 44: {
                Class clazz = evaluator.findClass((String)objectArray[1]);
                bl = clazz.isInstance(objectArray[0]);
                break;
            }
            default: {
                new Exception().printStackTrace();
            }
        }
        if (object != null) {
            return object;
        }
        return new Boolean(bl);
    }

    public Object operate(String[] stringArray, Evaluator evaluator) {
        boolean bl = false;
        Object var4_4 = null;
        int n = 0;
        if (stringArray[0] == null) {
            switch (this.operator()) {
                case 130: {
                    return new Boolean(false);
                }
                case 129: 
                case 132: {
                    return new Boolean(stringArray[1] == null);
                }
                case 131: {
                    return new Boolean(stringArray[1] == null);
                }
            }
        }
        if (stringArray[1] == null) {
            n = -1;
        }
        if (stringArray[0] != null && stringArray[1] != null) {
            n = stringArray[0].compareTo(stringArray[1]);
        }
        switch (this.operator()) {
            case 130: {
                bl = n > 0;
                break;
            }
            case 129: {
                bl = n < 0;
                break;
            }
            case 132: {
                bl = n >= 0;
                break;
            }
            case 131: {
                bl = n <= 0;
                break;
            }
            case 128: {
                bl = n == 0;
                break;
            }
            case 127: {
                bl = n != 0;
            }
        }
        return new Boolean(bl);
    }

    public String separator() {
        String string = "";
        switch (this.operation) {
            case 128: {
                string = "==";
                break;
            }
            case 127: {
                string = "!=";
                break;
            }
            case 130: {
                string = ">";
                break;
            }
            case 129: {
                string = "<";
                break;
            }
            case 132: {
                string = ">=";
                break;
            }
            case 131: {
                string = "<=";
                break;
            }
            case 44: {
                string = "-is-";
                break;
            }
            case 123: {
                string = "&&";
                break;
            }
            case 122: {
                string = "||";
                break;
            }
            default: {
                return super.separator();
            }
        }
        string = " " + string + " ";
        return string;
    }
}

