% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F1.R
\name{F1}
\alias{F1}
\title{Compute F1 score for JointNets result}
\usage{
F1(result, simulatedgraphs, ...)
}
\arguments{
\item{result}{output generated from any one of the jointnet algorithms}

\item{simulatedgraphs}{$simulatedgraphs from function simulation()}

\item{...}{unused}
}
\value{
F1 scores (F1 score for each context and the shared part (for simule and wsimule))
}
\description{
Compute F1 score for JointNets result
}
\examples{
library(JointNets)
simulationresult = simulation(p = 20,  n = c(100,100))
truth = simulationresult$simulatedgraphs
result = simule(simulationresult$simulatedsamples, 0.2, 0.5, covType = "cov", FALSE)
F1(result,truth)
}
\author{
Zhaoyang Wang (Author), Zhaoyang Wang (maintainer) \email{zw4dn@virginia.edu}
}
