% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/booter.R
\name{bootKernel}
\alias{bootKernel}
\title{Boot the Juniper Kernel}
\usage{
bootKernel()
}
\description{
Juniper Kernel Booter
}
\details{
This method is invoked programatically by a Jupyter client. In fact,
it's this method that appears in the \code{kernels.json} file at the
install location of the Juniper kernel. This kernel expects that a
Jupyter client will pass the connection file via the command line.
A connection file contains json that is similar to:
 \preformatted{
   \{
     "stdin_port": 61144,
     "transport": "tcp",
     "ip": "127.0.0.1",
     "iopub_port": 61143,
     "hb_port": 61146,
     "key": "cc496d37-59a9-4c61-8900-d826985f564d",
     "shell_port": 61142,
     "control_port": 61145
   \}
 }

This file is generated by the Jupyter client in the install directory of the
kernel. For example, if the Juniper kernel were installed on macOS with the
\code{--user} flag, the generated json file would have a file path of
  ~/Library/Jupyter/runtime/kernel-7a172737-797e-4b90-9e81-720eb8b999ab.json

See http://jupyter-client.readthedocs.io/en/latest/kernels.html#connection-files
for more details.
}
\examples{
\dontrun{
  /path/to/R -e 'JuniperKernel::bootKernel()' --args /path/to/connection_file.json
}

}
