% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MKM_Null_Model.R
\name{MKM_Null_Model}
\alias{MKM_Null_Model}
\title{KM for Multiple Quantitative Traits in GWAS Data (fit null model)}
\usage{
MKM_Null_Model(phenotype, trait, yid, covariates = NULL, eq.cov.effect = F)
}
\arguments{
\item{phenotype}{A vector of quantitative trait in the analysis (class: vector). The order should match the vector yid. No missing.}

\item{trait}{A vector of multivariate traits (class: vector). The order should match the vector yid. No missing.}

\item{yid}{A vector of id (class: vector). Although it doesn't have to be sorted, observations from the same subject have to be connected with each other. The repeated id numbers indicate multiple traits for one subject. Make sure it is not a factor. No missing.}

\item{covariates}{A matrix of covariates (class: data.frame). The order of rows should match the vector yid. Default NULL. No missing.}

\item{eq.cov.effect}{Whether assume equal covariates effects on different traits (Default=False).}
}
\value{
output: object as input for MKM
}
\description{
This function (MKM) is used to perform KM analysis (Tzeng et al. 2012) for multiple (two) quantitative traits in GWAS data. \cr
# It considers variances of trait 1 and 2, and covariance between trait 1 and 2
}

