% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hhgsurv_test_stat_K_sample}
\alias{hhgsurv_test_stat_K_sample}
\title{A function to return the test statistic of the KONP K-sample test}
\usage{
hhgsurv_test_stat_K_sample(s_group, time_group, n_vec, time, delta, trt,
  tau_k, tau)
}
\arguments{
\item{s_group}{A list with the survival KM estimates for all sorted unique times in each group, each group is an element in the list}

\item{time_group}{A list with all sorted unique in each group, each group is an element in the list}

\item{n_vec}{A vector with the sample sizes in each group}

\item{time}{The follow up time for all the data}

\item{delta}{A binary status vector, where 0 stands for censored observations and 1 stands for events (corresponds with time)}

\item{trt}{Group vector, contains the values 1,..,K only, which correspond with time}

\item{tau_k}{A vector contains maximum times in which we can estimate the Kaplan Meier in each group}

\item{tau}{The maximum time in which we can estimate the Kaplan Meier in at least two groups}
}
\value{
A list with the two test statistic
}
\description{
A function to return the test statistic of the KONP K-sample test
}
\details{
This is an inner function inside SG package, not for the users.
}
