% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plinkformat.R
\name{write.bed}
\alias{write.bed}
\title{Write an list of SNP object to the binary PLINK format (BED, BIM, and FAM)}
\usage{
write.bed(object, file)
}
\arguments{
\item{object}{An object of SNP is a list consisting of 3 matrices, see the
\emph{Details} section for more details.}

\item{file}{A prefix of output files for BED, BIM and FAM to be saved.}
}
\value{
\code{NULL}.
}
\description{
Write a SNP object to the files in the binary
PLINK format. For more information about the binary PLINK format, please
check in the manual of PLINK.
}
\details{
The \code{object} should contain:
\itemize{
\item \code{$snp} is a SNP matrix from BED file.
\item \code{$snp.info} is a data.frame of SNP information from BIM file.
\item \code{$ind.info} is a data.frame of individual information from FAM file.
}

For more details about the binary PLINK format, please check
\url{http://zzz.bwh.harvard.edu/plink/binary.shtml}
}
\examples{


#Load example data
data(example_SNP)

#Save 'simsnp' to the file as defined in 'save.file'
save.file <- file.path(tempdir(),"new_SNP")
write.bed(simsnp , save.file)
}
\seealso{
\code{\link{read.bed}}
}
