/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import kr.ac.kaist.swrc.jhannanum.comm.Eojeol;
import kr.ac.kaist.swrc.jhannanum.comm.PlainSentence;
import kr.ac.kaist.swrc.jhannanum.comm.SetOfSentences;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.AnalyzedDic;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.Connection;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.ConnectionNot;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.MorphemeChart;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.NumberDic;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.PostProcessor;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.Simti;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.Trie;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.MorphAnalyzer;
import kr.ac.kaist.swrc.jhannanum.share.JSONReader;
import kr.ac.kaist.swrc.jhannanum.share.TagSet;

public class ChartMorphAnalyzer
implements MorphAnalyzer {
    private static final String PLUG_IN_NAME = "MorphAnalyzer";
    private AnalyzedDic analyzedDic = null;
    private Trie systemDic = null;
    private Trie userDic = null;
    private NumberDic numDic = null;
    private TagSet tagSet = null;
    private Connection connection = null;
    private ConnectionNot connectionNot = null;
    private MorphemeChart chart = null;
    private Simti simti = null;
    private String fileConnectionsNot = "";
    private String fileConnections = "";
    private String fileDicAnalyzed = "";
    private String fileDicSystem = "";
    private String fileDicUser = "";
    private String fileTagSet = "";
    private LinkedList<Eojeol> eojeolList = null;
    private PostProcessor postProc = null;

    public String getName() {
        return PLUG_IN_NAME;
    }

    private Eojeol[] processEojeol(String plainEojeol) {
        String analysis = this.analyzedDic.get(plainEojeol);
        this.eojeolList.clear();
        if (analysis != null) {
            StringTokenizer st = new StringTokenizer(analysis, "^");
            while (st.hasMoreTokens()) {
                String analyzed = st.nextToken();
                String[] tokens = analyzed.split("\\+|/");
                String[] morphemes = new String[tokens.length / 2];
                String[] tags = new String[tokens.length / 2];
                int i = 0;
                int j = 0;
                while (i < morphemes.length) {
                    morphemes[i] = tokens[j++];
                    tags[i] = tokens[j++];
                    ++i;
                }
                Eojeol eojeol = new Eojeol(morphemes, tags);
                this.eojeolList.add(eojeol);
            }
        } else {
            this.chart.init(plainEojeol);
            this.chart.analyze();
            this.chart.getResult();
        }
        return this.eojeolList.toArray(new Eojeol[0]);
    }

    @Override
    public SetOfSentences morphAnalyze(PlainSentence ps) {
        StringTokenizer st = new StringTokenizer(ps.getSentence(), " \t");
        String plainEojeol = null;
        int eojeolNum = st.countTokens();
        ArrayList<String> plainEojeolArray = new ArrayList<String>(eojeolNum);
        ArrayList<Eojeol[]> eojeolSetArray = new ArrayList<Eojeol[]>(eojeolNum);
        while (st.hasMoreTokens()) {
            plainEojeol = st.nextToken();
            plainEojeolArray.add(plainEojeol);
            eojeolSetArray.add(this.processEojeol(plainEojeol));
        }
        SetOfSentences sos = new SetOfSentences(ps.getDocumentID(), ps.getSentenceID(), ps.isEndOfDocument(), plainEojeolArray, eojeolSetArray);
        sos = this.postProc.doPostProcessing(sos);
        return sos;
    }

    @Override
    public void initialize(String baseDir, String configFile) throws Exception {
        JSONReader json = new JSONReader(String.valueOf(baseDir) + "/" + configFile);
        this.fileDicSystem = String.valueOf(baseDir) + "/" + json.getValue("dic_system");
        this.fileDicUser = String.valueOf(baseDir) + "/" + json.getValue("dic_user");
        System.out.println(this.fileDicUser);
        this.fileConnections = String.valueOf(baseDir) + "/" + json.getValue("connections");
        this.fileConnectionsNot = String.valueOf(baseDir) + "/" + json.getValue("connections_not");
        this.fileDicAnalyzed = String.valueOf(baseDir) + "/" + json.getValue("dic_analyzed");
        this.fileTagSet = String.valueOf(baseDir) + "/" + json.getValue("tagset");
        this.tagSet = new TagSet();
        this.tagSet.init(this.fileTagSet, 0);
        this.connection = new Connection();
        this.connection.init(this.fileConnections, this.tagSet.getTagCount(), this.tagSet);
        this.connectionNot = new ConnectionNot();
        this.connectionNot.init(this.fileConnectionsNot, this.tagSet);
        this.analyzedDic = new AnalyzedDic();
        this.analyzedDic.readDic(this.fileDicAnalyzed);
        this.systemDic = new Trie(1060000);
        this.systemDic.read_dic(this.fileDicSystem, this.tagSet);
        this.userDic = new Trie(106000);
        this.userDic.read_dic(this.fileDicUser, this.tagSet);
        this.numDic = new NumberDic();
        this.simti = new Simti();
        this.simti.init();
        this.eojeolList = new LinkedList();
        this.chart = new MorphemeChart(this.tagSet, this.connection, this.systemDic, this.userDic, this.numDic, this.simti, this.eojeolList);
        this.postProc = new PostProcessor();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void loadUserDic(String Path2) {
    }
}

