% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L1centLOC.R
\name{L1centLOC}
\alias{L1centLOC}
\alias{L1centLOC.igraph}
\alias{L1centLOC.matrix}
\title{Local L1 Centrality}
\usage{
L1centLOC(g, eta, alpha)

\method{L1centLOC}{igraph}(g, eta = NULL, alpha)

\method{L1centLOC}{matrix}(g, eta = NULL, alpha)
}
\arguments{
\item{g}{An \code{igraph} graph object or a distance matrix. The graph must
be undirected and connected. Equivalently, the distance matrix must be
symmetric, and all entries must be finite.}

\item{eta}{An optional positive multiplicity (weight) vector for (vertex)
weighted networks. If set to \code{NULL} (the default), all vertices will
have the same weight (multiplicity), i.e., \code{g} is treated as an
unweighted graph. The length of the \code{eta} must be equivalent to the
number of vertices.}

\item{alpha}{A number or a numeric vector of multiscale parameters. Values
must be between 0 and 1.}
}
\value{
A list of numeric vectors. The length of the list is equivalent to
the length of \code{alpha}, and the names of the list are the values of
\code{alpha}. Each component of the list is a numeric vector whose length
is equivalent to the number of vertices in the graph \code{g}.
Specifically, the \code{i}th component of the list is a vector of local
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality at level
\code{alpha[i]} for each vertex.
}
\description{
Computes local \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
centrality at each \code{alpha} level for every vertex.
}
\details{
Suppose that the given graph has \eqn{n} vertices. We choose about
\eqn{n\alpha} vertices
(\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality-based
neighborhood) for each vertex (see \code{\link[=L1centNB]{L1centNB()}}), and compute the
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality of the vertex
conditioned on these vertices, i.e., derive the
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality locally.
}
\note{
The function is valid only for undirected and connected graphs.
}
\examples{
weight <- igraph::V(MCUmovie)$worldwidegross
MCUmovie_cent <- L1cent(MCUmovie, eta = weight)
MCUmovie_loc_cent <- L1centLOC(MCUmovie, eta = weight, alpha = 5/32)
plot(MCUmovie_cent, MCUmovie_loc_cent[[1]],
     xlab="Global L1 centrality", ylab="Local L1 centrality (alpha = 5/32)",
     main="MCU movie network: global vs. local centrality")
graphics::text(MCUmovie_cent, MCUmovie_loc_cent[[1]], igraph::V(MCUmovie)$name)
}
\references{
S. Kang and H.-S. Oh. On a notion of graph centrality based on
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} data depth.
Technical Report, 2023.
}
\seealso{
\code{\link[=L1cent]{L1cent()}} for
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality,
\code{\link[=L1centNB]{L1centNB()}} for \ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}}
centrality-based neighborhood.
}
